/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.pcap;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.pcap.PcapManager;
import org.qubership.automation.itf.core.util.pcap.PcapManagersCache;
import org.qubership.automation.itf.core.util.pcap.PcapThread;
import org.qubership.automation.itf.core.util.pcap.PcapThreadsCache;
import org.qubership.automation.itf.core.util.services.CoreServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcapHelper {
    private static final Logger log = LoggerFactory.getLogger(PcapHelper.class);
    public static String TCPDUMP_FILTER_KEY = "tcpdumpFilter";
    public static String TCPDUMP_NETWORK_INTERFACE_NAME_KEY = "networkInterfaceName";
    public static String TCPDUMP_PACKET_COUNT_KEY = "packetCount";

    public static void createPcapManager(String id, BigInteger projectId, String niName, String filter, String packetCount) {
        int maxPacketCount;
        if (StringUtils.isBlank((CharSequence)niName) || StringUtils.isBlank((CharSequence)packetCount)) {
            log.error("Required parameters are missed - TCP dump is disabled. Network interface name: {}, Packet count: {}", (Object)niName, (Object)packetCount);
        }
        String dumpfilePath = String.format("%s/%s/%s.pcap", Config.getConfig().getString("tcpdump.folder"), projectId.toString(), id);
        try {
            maxPacketCount = Integer.parseInt(packetCount);
        }
        catch (NumberFormatException e) {
            log.error("Error while parsing the packet count parameter - default value will be used. Error: " + e);
            maxPacketCount = CoreServices.getProjectSettingsService().getInt((Object)projectId, "tcpdump.packet.count.default", Integer.parseInt("50"));
        }
        PcapManagersCache.getInstance().add(id, new PcapManager(dumpfilePath, niName, filter, maxPacketCount));
    }

    public static String startTcpDumpCreating(String id) {
        String dumpfilePath = "";
        PcapManager pcapManager = PcapManagersCache.getInstance().getPcapManager(id);
        if (pcapManager != null) {
            log.info("Start of creating the tcp-dump for context: " + id);
            PcapThread pcapThread = new PcapThread(pcapManager, id);
            PcapThreadsCache.getInstance().add(id, pcapThread);
            pcapThread.start();
            dumpfilePath = Config.getConfig().getRunningUrl() + "tcpdump/" + id + ".pcap";
        }
        return dumpfilePath;
    }

    public static void stopTcpDumpCreating(String id) {
        PcapThread pcapThread = PcapThreadsCache.getInstance().get(id);
        if (pcapThread != null) {
            log.info("End of creating tcp-dump for context: " + id);
            pcapThread.stopThread();
        }
    }

    private static String createFilepath(String filename) {
        try {
            String host = Inet4Address.getLocalHost().getCanonicalHostName();
            String port = System.getProperties().getProperty("port");
            if (StringUtils.isEmpty((CharSequence)port)) {
                port = "8080";
            }
            return String.format("http://%s:%s/%s", host, port, filename);
        }
        catch (UnknownHostException e) {
            log.error("Can't identify the host. Link to the created file with TCPDump will not be created. You can find the file in ITF-folder.");
            return "";
        }
    }
}

