/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.pcap;

import java.io.File;
import java.io.IOException;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapDumper;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.packet.Packet;
import org.qubership.automation.itf.core.util.pcap.CustomNifSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PcapManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PcapManager.class);
    private PcapHandle handle = null;
    private PcapDumper dumper = null;
    private int snapshotLength = 65536;
    private int readTimeout = 5;
    private int maxPackets;
    private String filter;
    private String filename;

    public PcapManager(String filename, String networkInterfaceName, String filter, int maxPackets) {
        this.filter = filter;
        this.filename = filename;
        this.maxPackets = maxPackets;
        this.createHandle(networkInterfaceName);
        this.createDumper();
    }

    public void startPcapFileCreating() {
        if (this.handle != null && this.dumper != null) {
            try {
                this.handle.setFilter(this.filter, BpfProgram.BpfCompileMode.OPTIMIZE);
                PacketListener listener = new PacketListener(){

                    public void gotPacket(Packet packet) {
                        try {
                            PcapManager.this.dumper.dump(packet, PcapManager.this.handle.getTimestamp());
                            LOGGER.debug("Packet is added to dump file {}", (Object)PcapManager.this.getFilename());
                        }
                        catch (NotOpenException e) {
                            LOGGER.error("Adding of the packet to dump has been failed. Execution will be interrupted.", (Throwable)e);
                            PcapManager.this.interruptExecution();
                        }
                    }
                };
                try {
                    this.handle.loop(this.maxPackets, listener);
                }
                catch (InterruptedException e) {
                    LOGGER.info("Packet listening has been interrupted. Execution will be interupted.");
                    this.interruptExecution();
                }
                this.interruptExecution();
            }
            catch (NotOpenException | PcapNativeException e) {
                LOGGER.error("Error while setting the filter: {}. Execution will be interupted.", (Object)this.filter);
                this.interruptExecution();
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void stopPcapFileCreating() {
        try {
            this.handle.breakLoop();
        }
        catch (NotOpenException e) {
            LOGGER.error("Exception while stopping the packet listening");
        }
    }

    private void createHandle(String networkInterfaceName) {
        PcapNetworkInterface networkDevice = this.getNetworkDevice(networkInterfaceName);
        if (networkDevice != null) {
            try {
                this.handle = networkDevice.openLive(this.snapshotLength, PcapNetworkInterface.PromiscuousMode.NONPROMISCUOUS, this.readTimeout);
            }
            catch (PcapNativeException e) {
                LOGGER.error("Error while creating the PcapHandle object: " + (Object)((Object)e));
            }
        }
    }

    private void createDumper() {
        if (this.handle != null) {
            try {
                new File(this.filename).createNewFile();
                this.dumper = this.handle.dumpOpen(this.filename);
            }
            catch (NotOpenException | PcapNativeException e) {
                LOGGER.error("Error while creating the PcapDumper object: " + e);
                this.handle.close();
            }
            catch (IOException e) {
                LOGGER.error("Error while creating the file for the tcp-dump: " + e);
                this.handle.close();
            }
        }
    }

    private PcapNetworkInterface getNetworkDevice(String networkInterfaceName) {
        PcapNetworkInterface device = null;
        try {
            device = new CustomNifSelector(networkInterfaceName).selectNetworkInterface();
        }
        catch (IOException e) {
            LOGGER.error("Error while selecting the device by its name: " + networkInterfaceName);
        }
        return device;
    }

    private void interruptExecution() {
        this.dumper.close();
        this.handle.close();
        Thread.currentThread().interrupt();
    }
}

