/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 *
 */

package org.qubership.automation.itf.core.exceptions.common;

import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.exceptions.ItfExecutorException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

//reason code of common exceptions starts with 0
@ResponseStatus(value = HttpStatus.INTERNAL_SERVER_ERROR, reason = "ITFEXE-0003")
public class ObjectNotFoundException extends ItfExecutorException {
    public static final String DEFAULT_MESSAGE = "%s [ID=%s]%s not found%s";
    private static final String NAME_INSERT = "[name=%s] ";
    private static final String OPERATION_INSERT = " while trying to %s";

    public ObjectNotFoundException(String type, String id, String name, String operation) {
        super(String.format(DEFAULT_MESSAGE,
                        type,
                        id,
                        StringUtils.isNotEmpty(name) ? String.format(NAME_INSERT, name) : "",
                        StringUtils.isNotEmpty(operation) ? String.format(OPERATION_INSERT, operation) : ""
                )
        );
    }

}
