/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.chain;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.OperationEventTriggerObjectManager;
import org.qubership.automation.itf.core.message.parser.Parser;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.event.StepEvent;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.model.jpa.message.parser.ParsingRule;
import org.qubership.automation.itf.core.model.jpa.message.template.Template;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.OperationEventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.exception.KeyDefinitionException;
import org.qubership.automation.itf.core.util.exception.OperationDefinitionException;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.helper.KeyHelper;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.provider.ParsingRuleProvider;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.cache.service.impl.BoundContextsCacheService;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IncomingHelper {
    private static final Logger log = LoggerFactory.getLogger(IncomingHelper.class);
    public static final Step UNEXPECTED_STEP = new IntegrationStep(){
        {
            this.setName("Undefined step");
        }

        public System getReceiver() {
            return null;
        }

        public System getSender() {
            return null;
        }

        public Operation getOperation() {
            return null;
        }

        public Template returnStepTemplate() {
            return null;
        }

        public Mep getMep() {
            return Mep.INBOUND_REQUEST_ASYNCHRONOUS;
        }

        public Situation getParent() {
            return null;
        }
    };
    public static final Situation UNEXPECTED_SITUATION = new Situation(){

        public List<Step> getSteps() {
            return Collections.singletonList(UNEXPECTED_STEP);
        }

        public String getName() {
            return "Unexpected situation";
        }
    };
    private final EventBusProvider eventBusProvider;

    public String getContextKey(InstanceContext context, @Nonnull System system, @Nullable Operation operation, boolean throwKeyDefinitionException) throws KeyDefinitionException {
        log.debug("Define context key");
        Operation parent = null;
        String contextDefinition = null;
        if (operation != null) {
            contextDefinition = operation.getIncomingContextKeyDefinition();
            parent = operation;
        }
        if (Strings.isNullOrEmpty(contextDefinition)) {
            contextDefinition = system.getIncomingContextKeyDefinition();
            parent = system;
        }
        if (Strings.isNullOrEmpty((String)contextDefinition)) {
            if (throwKeyDefinitionException) {
                throw new KeyDefinitionException(system, operation);
            }
            return null;
        }
        String contextKey = KeyHelper.defineKey((String)contextDefinition, (InstanceContext)context, (Storable)parent);
        log.debug("Context key is: " + contextKey);
        return contextKey;
    }

    public TcContext findOrCreateTcContextByKeys(String contextKey, String isStub, BigInteger projectId, UUID projectUuid) {
        if (StringUtils.isBlank((CharSequence)contextKey)) {
            return ExecutionServices.getTCContextService().createInMemory(projectId, projectUuid);
        }
        String[] contextKeys = contextKey.split("\\(\\+key\\)\\n");
        BoundContextsCacheService boundContextsCacheService = CacheServices.getTcBindingCacheService();
        if (isStub != null && isStub.equals("Yes")) {
            return contextKeys.length == 1 ? boundContextsCacheService.createByKey(contextKey, true, projectId, projectUuid) : boundContextsCacheService.createByKeys(contextKeys, true, projectId, projectUuid);
        }
        return contextKeys.length == 1 ? boundContextsCacheService.findByKey(contextKey, projectId, projectUuid) : boundContextsCacheService.findByKeys(contextKeys, projectId, projectUuid);
    }

    public Operation processIncomingMessage(Message message, InstanceContext context, TransportConfiguration transport, BigInteger projectId, UUID projectUuid) throws Exception {
        System system = transport.getParent();
        Parser parser = new Parser();
        log.debug("Parse general message parameters to define operation");
        Map systemMessageParameters = parser.parse(projectId, message, context, new ParsingRuleProvider[]{system});
        context.sp().putMessageParameters(systemMessageParameters.values());
        log.debug("Define operation using this parsed parameters");
        try {
            Operation operation = system.defineOperation(context);
            log.info("Operation is: " + operation.getName());
            Set<ParsingRule> parsingRuleWithoutSituationParsingRules = this.getParsingRulesWithoutSituationParsingRules(operation);
            log.debug("Parse concrete message parameters for specific operation");
            Map operationMessageParameters = parser.parse(projectId, message, context, parsingRuleWithoutSituationParsingRules);
            context.sp().putMessageParameters(operationMessageParameters.values());
            return operation;
        }
        catch (OperationDefinitionException e) {
            TcContext tcContext;
            try {
                String contextKey = this.getContextKey(context, system, null, true);
                tcContext = this.findOrCreateTcContextByKeys(contextKey, "No", projectId, projectUuid);
            }
            catch (KeyDefinitionException e1) {
                log.error("Cannot define context to log error, automatic context for exception is created", (Throwable)e);
                tcContext = this.findOrCreateTcContextByKeys("Error Context key", "No", projectId, projectUuid);
                tcContext.setName("Error Context");
            }
            tcContext.setProjectId(projectId);
            tcContext.setProjectUuid(context.getProjectUuid());
            tcContext.setStartedFrom(StartedFrom.ITF_STUB);
            tcContext.setAndCalculateNeedToReportToItf();
            context.setTC(tcContext);
            throw e;
        }
    }

    public Map<String, MessageParameter> processOutboundResponseMessage(System system, Operation operation, Situation situation, Message message, InstanceContext instanceContext, BigInteger projectId) {
        Parser parser = new Parser();
        Map messageParameters = parser.parse(projectId, message, instanceContext, (Collection)system.returnParsingRules());
        if (situation.getParsingRules().isEmpty()) {
            messageParameters.putAll(parser.parse(projectId, message, instanceContext, (Collection)operation.returnParsingRules()));
        } else {
            messageParameters.putAll(parser.parse(projectId, message, instanceContext, (Collection)situation.getParsingRules()));
        }
        return messageParameters;
    }

    private StepInstance createUnexpectedStepInstance(InstanceContext context, SituationInstance unexpectedSituation, Throwable error) {
        StepInstance stepInstance = new StepInstance();
        stepInstance.setID((Object)UniqueIdGenerator.generate());
        stepInstance.init(UNEXPECTED_STEP);
        stepInstance.getContext().putAll((Map)context);
        stepInstance.setParent((AbstractInstance)unexpectedSituation);
        stepInstance.setError(error);
        stepInstance.setStartTime(context.getTC().getStartTime());
        stepInstance.setEndTime(new Date());
        stepInstance.setStatus(Status.FAILED);
        stepInstance.getContext().setProjectUuid(context.getProjectUuid());
        stepInstance.getContext().setProjectId(context.getProjectId());
        unexpectedSituation.getStepInstances().add(stepInstance);
        return stepInstance;
    }

    private SituationInstance createUnexpectedSituationInstance(InstanceContext context, Throwable error) {
        SituationInstance unexpectedSituation = new SituationInstance();
        unexpectedSituation.setID((Object)UniqueIdGenerator.generate());
        unexpectedSituation.setParentContext(context.getTC());
        unexpectedSituation.getContext().putAll((Map)context);
        unexpectedSituation.setStepContainer((StepContainer)UNEXPECTED_SITUATION);
        unexpectedSituation.setError(error);
        unexpectedSituation.setStartTime(context.getTC().getStartTime());
        unexpectedSituation.setEndTime(new Date());
        unexpectedSituation.setStatus(Status.FAILED);
        unexpectedSituation.getContext().setProjectUuid(context.getProjectUuid());
        unexpectedSituation.getContext().setProjectId(context.getProjectId());
        unexpectedSituation.setName("*** Runtime exception occurred ***");
        return unexpectedSituation;
    }

    public void executeUnexpectedSituation(InstanceContext context, Exception e) {
        SituationInstance unexpectedSituation = this.createUnexpectedSituationInstance(context, e);
        StepInstance unexpectedStepInstance = this.createUnexpectedStepInstance(context, unexpectedSituation, e);
        context.tc().setInitiator((AbstractContainerInstance)unexpectedSituation);
        ExecutionServices.getTCContextService().fail(context.tc());
        this.eventBusProvider.post((Event)new SituationEvent.Start(unexpectedSituation));
        this.eventBusProvider.post((Event)new StepEvent.Start(unexpectedStepInstance));
        this.eventBusProvider.post((Event)new StepEvent.Terminate(unexpectedStepInstance));
        this.eventBusProvider.post((Event)new SituationEvent.Terminate(unexpectedSituation));
    }

    public Situation detectSituationFromOperation(Operation operation, JsonContext context) {
        log.debug("getAllActive OperationEventTrigger request to DB - started");
        List operationEventTriggers = ((OperationEventTriggerObjectManager)CoreObjectManager.getInstance().getSpecialManager(OperationEventTrigger.class, OperationEventTriggerObjectManager.class)).getAllActive(operation);
        log.debug("getAllActive OperationEventTrigger request to DB - finished");
        for (EventTrigger eventTrigger : operationEventTriggers) {
            List conditionParameters = eventTrigger.getConditionParameters();
            if (conditionParameters == null || conditionParameters.isEmpty()) {
                log.info("Situation {}: conditions are empty; situation is to be executed", (Object)eventTrigger.getParent());
                return (Situation)eventTrigger.getParent();
            }
            if (!ConditionsHelper.isApplicable((JsonContext)context, (List)conditionParameters)) continue;
            return (Situation)eventTrigger.getParent();
        }
        return operation.getDefaultIfInbound();
    }

    public void tryToGetRequestMethod(Message message, InstanceContext context) {
        Object method = message.getConnectionProperties().get("method");
        if (method != null) {
            context.sp().put((Object)"method", method);
        }
    }

    public Set<ParsingRule> getParsingRulesWithoutSituationParsingRules(Operation operation) {
        HashSet result = Sets.newHashSet();
        Set operationParsingRules = operation.returnParsingRules();
        if (!operationParsingRules.isEmpty()) {
            HashSet situationsParsingRules = Sets.newHashSet();
            for (Situation situation : operation.getSituations()) {
                situationsParsingRules.addAll(situation.getParsingRules());
            }
            for (ParsingRule operationParsingRule : operationParsingRules) {
                if (situationsParsingRules.contains(operationParsingRule)) continue;
                result.add(operationParsingRule);
            }
        }
        return result;
    }

    @ConstructorProperties(value={"eventBusProvider"})
    public IncomingHelper(EventBusProvider eventBusProvider) {
        this.eventBusProvider = eventBusProvider;
    }
}

