/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.AbstractSituationSubscriber;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;

public class StepEndSituationSubscriber
extends AbstractSituationSubscriber {
    private final Map<Situation, Boolean> endSituations = new HashMap<Situation, Boolean>();
    private final boolean waitAllEndSituations;

    public StepEndSituationSubscriber(TcContext context, Set<Situation> endSituations, String callChainEventId, boolean waitAllEndSituations) {
        super(context, callChainEventId);
        this.setMapEndSituations(endSituations);
        this.waitAllEndSituations = waitAllEndSituations;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handle(SituationEvent.EndExceptionalSituationFinish event) {
        TenantContext.setTenantInfo((String)this.getTenantId(event));
        Situation situation = event.getSituationInstance().getSituationById();
        if (event.getSituationInstance().getContext().tc().equals((Object)this.getContext()) && this.endSituations.containsKey(situation)) {
            if (!this.waitAllEndSituations) {
                LOGGER.info("Got event Situation {} finished in context {}. Will trigger next call in chain...", (Object)situation.getName(), (Object)this.getContext().getName());
                this.finish(event);
            } else {
                this.endSituations.replace(situation, true);
                if (this.allSituationsIsFinished()) {
                    LOGGER.info("Got event Situation {} finished in context {}. Will trigger next call in chain...", (Object)situation.getName(), (Object)this.getContext().getName());
                    this.finish(event);
                }
            }
        } else {
            LOGGER.debug("Ignoring event {}", (Object)event);
        }
    }

    @Override
    protected NextCallChainEvent createEvent() {
        return new NextCallChainEvent(this.getParentEventID(), null);
    }

    private void setMapEndSituations(Set<Situation> endSituations) {
        for (Situation situation : endSituations) {
            this.endSituations.put(situation, false);
        }
    }

    private boolean allSituationsIsFinished() {
        for (boolean isFinished : this.endSituations.values()) {
            if (isFinished) continue;
            return false;
        }
        return true;
    }
}

