/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.metric;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.execution.WaitTimeMonitoringThreadPoolExecutor;
import org.qubership.automation.itf.core.metric.Metric;
import org.qubership.automation.itf.core.metric.MetricTag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
public class MetricsAggregateService {
    private final MeterRegistry meterRegistry;
    private Counter.Builder executorCallChainCounter;
    private Counter.Builder executorContextSizeCounter;
    @Value(value="${message-broker.stubs-executor-incoming-request.queue}")
    private String destinationQueueName;
    private ApplicationContext applicationContext;
    private DefaultMessageListenerContainer defaultMessageListenerContainer;
    private JmsListenerEndpointRegistry jmsListenerEndpointRegistry;

    @Autowired
    public MetricsAggregateService(ApplicationContext applicationContext, JmsListenerEndpointRegistry jmsListenerEndpointRegistry, MeterRegistry meterRegistry) {
        this.applicationContext = applicationContext;
        this.jmsListenerEndpointRegistry = jmsListenerEndpointRegistry;
        this.meterRegistry = meterRegistry;
        this.executorCallChainCounter = Counter.builder((String)Metric.ATP_ITF_EXECUTOR_CALLCHAIN_COUNT_BY_PROJECT.getValue()).tags(new String[]{MetricTag.PROJECT.getValue(), "", MetricTag.CALLCHAIN_NAME.getValue(), ""}).description("total number of running call chains");
        this.executorContextSizeCounter = Counter.builder((String)Metric.ATP_ITF_EXECUTOR_CONTEXT_SIZE_BY_PROJECT.getValue()).tags(new String[]{MetricTag.PROJECT.getValue(), "", MetricTag.CALLCHAIN_NAME.getValue(), ""}).description("total size of testcase contexts");
    }

    @EventListener
    public void init(ContextRefreshedEvent event) {
        if (event.getSource().equals(this.applicationContext)) {
            this.contextInitialized();
            this.fillJmsListenerStatsMetric();
            this.fillExecutorPoolStatsMetric();
        }
    }

    public void incrementCallChainCountToProject(@NonNull UUID projectUuid, @NonNull String callChainName) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid");
        }
        if (callChainName == null) {
            throw new NullPointerException("callChainName");
        }
        this.executorCallChainCounter.tags(new String[]{MetricTag.PROJECT.getValue(), projectUuid.toString(), MetricTag.CALLCHAIN_NAME.getValue(), callChainName}).register(this.meterRegistry).increment();
    }

    public void incrementContextSizeCountToProject(@NonNull UUID projectUuid, @NonNull String callChainName, int size) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid");
        }
        if (callChainName == null) {
            throw new NullPointerException("callChainName");
        }
        if (StringUtils.isNotEmpty((CharSequence)callChainName)) {
            this.executorContextSizeCounter.tags(new String[]{MetricTag.PROJECT.getValue(), projectUuid.toString(), MetricTag.CALLCHAIN_NAME.getValue(), callChainName}).register(this.meterRegistry).increment((double)size);
        }
    }

    public void recordExecuteCallchainDuration(@NonNull UUID projectUuid, @NonNull String callChainName, @NonNull Duration duration) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid");
        }
        if (callChainName == null) {
            throw new NullPointerException("callChainName");
        }
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        this.meterRegistry.timer(Metric.ATP_ITF_EXECUTOR_CALLCHAIN_SECONDS_BY_PROJECT.getValue(), new String[]{MetricTag.PROJECT.getValue(), projectUuid.toString(), MetricTag.CALLCHAIN_NAME.getValue(), callChainName}).record(duration);
    }

    public void recordIncomingRequestDuration(@NonNull UUID projectUuid, @NonNull String endPoint, @NonNull Duration duration) {
        if (projectUuid == null) {
            throw new NullPointerException("projectUuid");
        }
        if (endPoint == null) {
            throw new NullPointerException("endPoint");
        }
        if (duration == null) {
            throw new NullPointerException("duration");
        }
        this.meterRegistry.timer(Metric.ATP_ITF_EXECUTOR_STUB_REQUEST_SECONDS_BY_PROJECT.getValue(), new String[]{MetricTag.PROJECT.getValue(), projectUuid.toString(), MetricTag.ENDPOINT.getValue(), endPoint}).record(duration);
    }

    private void contextInitialized() {
        for (MessageListenerContainer messageListenerContainer : this.jmsListenerEndpointRegistry.getListenerContainers()) {
            if (!this.destinationQueueName.equals(((DefaultMessageListenerContainer)messageListenerContainer).getDestinationName())) continue;
            this.defaultMessageListenerContainer = (DefaultMessageListenerContainer)messageListenerContainer;
            break;
        }
    }

    private void fillJmsListenerStatsMetric() {
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_JMS_LISTENER_THREAD_POOL_ACTIVE_SIZE, () -> this.defaultMessageListenerContainer.getActiveConsumerCount());
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_JMS_LISTENER_THREAD_POOL_MAX_SIZE, () -> this.defaultMessageListenerContainer.getMaxConcurrentConsumers());
    }

    private void fillExecutorPoolStatsMetric() {
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_REGULAR_POOL_ACTIVE_SIZE, () -> ((WaitTimeMonitoringThreadPoolExecutor)ExecutorServiceProviderFactory.get().requestForRegular()).getActiveCount());
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_REGULAR_POOL_MAX_SIZE, () -> ((WaitTimeMonitoringThreadPoolExecutor)ExecutorServiceProviderFactory.get().requestForRegular()).getMaximumPoolSize());
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_INBOUND_POOL_ACTIVE_SIZE, () -> ((ThreadPoolExecutor)ExecutorServiceProviderFactory.get().requestForInboundProcessing()).getActiveCount());
        this.initializeGauges(Metric.ATP_ITF_EXECUTOR_INBOUND_POOL_MAX_SIZE, () -> ((ThreadPoolExecutor)ExecutorServiceProviderFactory.get().requestForInboundProcessing()).getLargestPoolSize());
    }

    private void initializeGauges(Metric metric, Supplier<Number> function) {
        Gauge.builder((String)metric.getValue(), function).register(this.meterRegistry);
    }

    private void initializeGauges(UUID projectUuid, Metric metric, Map<UUID, AtomicInteger> metricsMap) {
        if (!metricsMap.containsKey(projectUuid)) {
            metricsMap.put(projectUuid, new AtomicInteger());
            Gauge.builder((String)metric.getValue(), () -> ((AtomicInteger)metricsMap.get(projectUuid)).get()).tag(MetricTag.PROJECT.getValue(), projectUuid.toString()).register(this.meterRegistry);
        }
    }
}

