/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.project.IntegrationConfig;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.report.ReportLinkCreator;
import org.qubership.automation.itf.core.util.constants.SituationLevelValidation;
import org.qubership.automation.itf.core.util.engine.EngineAfterIntegration;
import org.qubership.automation.itf.core.util.engine.EngineIntegration;
import org.qubership.automation.itf.core.util.engine.EngineOnStepIntegration;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.registry.EngineIntegrationRegistry;
import org.qubership.automation.itf.core.util.transport.service.report.Report;

public class ReportIntegration {
    private static ReportIntegration instance = new ReportIntegration();

    private ReportIntegration() {
    }

    public static ReportIntegration getInstance() {
        return instance;
    }

    private void runAfterIntegrations(CallChainInstance instance) {
        Set integrationConfs = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)instance.getContext().tc().getProjectId())).getIntegrationConfs();
        block2: for (Map.Entry item : EngineIntegrationRegistry.getInstance().getAvailableEngines().entrySet()) {
            if (!(item.getValue() instanceof EngineAfterIntegration)) continue;
            for (IntegrationConfig config : integrationConfs) {
                if (!config.getTypeName().equals(item.getKey())) continue;
                try {
                    ((EngineAfterIntegration)item.getValue()).executeAfter(instance, config);
                }
                catch (Exception ex) {
                    this.addInstanceException((AbstractContainerInstance)instance, "After-Callchain-Finished Integration", ex);
                }
                continue block2;
            }
        }
    }

    public boolean runOnStepIntegrations(SituationInstance instance, SpContext spContext, AbstractContainerInstance initiator, Situation situation) throws Exception {
        boolean passed = true;
        Set integrationConfs = ((StubProject)CoreObjectManager.getInstance().getManager(StubProject.class).getById((Object)instance.getContext().tc().getProjectId())).getIntegrationConfs();
        if (integrationConfs.isEmpty()) {
            return passed;
        }
        block2: for (Map.Entry item : EngineIntegrationRegistry.getInstance().getAvailableEngines().entrySet()) {
            if (!(item.getValue() instanceof EngineOnStepIntegration)) continue;
            for (IntegrationConfig config : integrationConfs) {
                if (!config.getTypeName().equals(item.getKey())) continue;
                try {
                    passed = passed && ((EngineOnStepIntegration)item.getValue()).executeOnStep(instance, spContext, initiator, config, situation);
                    continue block2;
                }
                catch (Exception ex) {
                    this.addInstanceException((AbstractContainerInstance)instance, (String)item.getKey() + ": exception on the step '" + instance.getName() + "'", ex);
                    if (situation.getValidateIncoming().equals((Object)SituationLevelValidation.IGNORE)) continue block2;
                    throw new Exception((String)item.getKey() + ": exception on the step '" + instance.getName() + "' with config " + config.getName() + " and engine " + ((EngineIntegration)item.getValue()).toString(), ex);
                }
            }
        }
        return passed;
    }

    void runAndReportAfterIntegrations(TcContext tcContext) {
        AbstractContainerInstance initiator = tcContext.getInitiator();
        if (initiator instanceof CallChainInstance) {
            this.runAfterIntegrations((CallChainInstance)initiator);
            this.reportReportLinks((CallChainInstance)initiator);
        }
    }

    private void addInstanceException(AbstractContainerInstance initiator, String where, Throwable exception) {
        String errName = initiator.getErrorName();
        String errMessage = initiator.getErrorMessage();
        initiator.setErrorName((StringUtils.isBlank((CharSequence)errName) ? "" : errName + " ...One more exception(s): ") + "[" + where + " Exception]" + exception.getMessage());
        initiator.setErrorMessage((StringUtils.isBlank((CharSequence)errMessage) ? "" : errMessage + " ...One more exception(s): ") + "[" + where + " Exception]" + (exception.getCause() != null ? exception.getCause().toString() : ExceptionUtils.getStackTrace((Throwable)exception)));
    }

    private void reportReportLinks(CallChainInstance chainInstance) {
        Report.info((AbstractInstance)chainInstance, (String)"Report links after execution", (String)ReportLinkCreator.getInstance().buildReportLinks(chainInstance.getContext().tc()));
    }
}

