/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.util.format;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.util.format.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Formatters {
    private static final Logger LOGGER = LoggerFactory.getLogger(Formatters.class);
    private static final DocumentBuilder XML_DOCUMENT_BUILDER;
    private static final Transformer XML_TRANSFORMER;
    private static final Formatter XML_FORMATTER;
    private static final Formatter EMPTY_FORMATTER;
    private static final Map<String, Formatter> FORMATTERS;

    private Formatters() {
    }

    private static DocumentBuilder initXmlDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.warn("XMLDocumentBuilder init is failed - formatting won't be applied to incoming XML messages", (Throwable)ex);
            return null;
        }
    }

    private static Transformer initXmlTransformer() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            return transformer;
        }
        catch (TransformerConfigurationException ex) {
            LOGGER.warn("XMLTransformer init is failed - formatting won't be applied to incoming XML messages", (Throwable)ex);
            return null;
        }
    }

    public static Formatter getFormatter(String transportClassName) {
        Formatter formatter = FORMATTERS.get(transportClassName);
        return formatter != null ? formatter : EMPTY_FORMATTER;
    }

    public static Formatter getFormatterOrNull(String transportClassName) {
        return FORMATTERS.get(transportClassName);
    }

    public static boolean isEmptyFormatter(Formatter formatter) {
        return EMPTY_FORMATTER.equals(formatter);
    }

    static {
        EMPTY_FORMATTER = text -> {
            LOGGER.debug("There is no appropriate formatter for the message. No format changes will be applied.");
            return text;
        };
        FORMATTERS = Maps.newHashMap();
        XML_DOCUMENT_BUILDER = Formatters.initXmlDocumentBuilder();
        XML_TRANSFORMER = Formatters.initXmlTransformer();
        XML_FORMATTER = new Formatter(){

            @Override
            public String format(String text) {
                if (XML_DOCUMENT_BUILDER == null || XML_TRANSFORMER == null) {
                    LOGGER.debug("XML formatting of the message escaped - xmlDocumentBuilder and/or xmlTransformer are NOT initialized.");
                    return text;
                }
                if (StringUtils.isBlank((CharSequence)text)) {
                    return text;
                }
                return this.formatXml(text);
            }

            private synchronized String formatXml(String text) {
                if (XML_DOCUMENT_BUILDER == null || XML_TRANSFORMER == null) {
                    return text;
                }
                try {
                    Document doc = XML_DOCUMENT_BUILDER.parse(new InputSource(new StringReader(text)));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    XML_TRANSFORMER.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8)));
                    return out.toString(StandardCharsets.UTF_8.name());
                }
                catch (Exception e) {
                    LOGGER.info("XML formatting of the message is failed - no format changes are applied. Change log level to DEBUG to see details.");
                    LOGGER.debug("XML formatting of the message is failed - no format changes are applied:", (Throwable)e);
                    return text;
                }
            }
        };
        if (XML_DOCUMENT_BUILDER != null && XML_TRANSFORMER != null) {
            FORMATTERS.put("org.qubership.automation.itf.transport.diameter.outbound.DiameterOutbound", XML_FORMATTER);
            FORMATTERS.put("org.qubership.automation.itf.transport.soap.jms.outbound.SoapOverJMSOutbound", XML_FORMATTER);
            FORMATTERS.put("org.qubership.automation.itf.transport.soap.http.outbound.SOAPOverHTTPOutboundTransport", XML_FORMATTER);
            FORMATTERS.put("org.qubership.automation.itf.transport.soap.jms.inbound.SoapOverJMSInbound", XML_FORMATTER);
            FORMATTERS.put("org.qubership.automation.itf.transport.soap.http.inbound.SOAPOverHTTPInboundTransport", XML_FORMATTER);
        }
    }
}

