/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.instance.situation.TCContextDiffCache;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.core.util.transport.service.LockProvider;
import org.qubership.automation.itf.core.util.transport.service.SessionHandler;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheCleanerService.class);
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final long initialDelay = 120L;
    private final long delay = 120L;
    private boolean stopped = false;
    private ReportLinkCollector reportLinkCollector;

    @Autowired
    public CacheCleanerService(ReportLinkCollector reportLinkCollector) {
        this.reportLinkCollector = reportLinkCollector;
    }

    public void startWorker() {
        LOGGER.info("Cache Cleaner Service is started.");
        this.service.scheduleWithFixedDelay(() -> {
            try {
                TCContextDiffCache.TC_CONTEXT_DIFF_CACHE.cleanUp();
                CacheServices.getCallchainSubscriberCacheService().cleanUp();
                SessionHandler.INSTANCE.cleanupCache();
                LockProvider.INSTANCE.cleanupCache();
                this.reportLinkCollector.cacheCleanup();
            }
            catch (Throwable t) {
                LOGGER.error("Error while TC Cache cleaning up", t);
            }
        }, 120L, 120L, TimeUnit.SECONDS);
    }

    public void stop() {
        LOGGER.info("Worker is stopped.");
        this.service.shutdown();
        this.stopped = true;
    }
}

