/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.hazelcast.listener;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.listener.EntryExpiredListener;
import org.apache.logging.log4j.util.Strings;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TCContextEntryExpiredListener
implements EntryExpiredListener<Object, TcContext> {
    private static final Logger log = LoggerFactory.getLogger(TCContextEntryExpiredListener.class);
    private Boolean multiTenancyEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entryExpired(EntryEvent entryEvent) {
        try {
            if (this.multiTenancyEnabled == null) {
                this.multiTenancyEnabled = (Boolean)ApplicationConfig.env.getProperty("atp.multi-tenancy.enabled", Boolean.class);
            }
            TcContext tcContext = (TcContext)entryEvent.getOldValue();
            String projectUuid = tcContext.getProjectUuid().toString();
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)projectUuid);
            MdcUtils.put((String)MdcField.CONTEXT_ID.toString(), (String)tcContext.getID().toString());
            if (this.multiTenancyEnabled.booleanValue()) {
                TenantContext.setTenantInfo((String)projectUuid);
            }
            if (!this.isContextCreatedOnThisPod(tcContext)) {
                log.info("Context initiated on another pod. TerminateByTimeout process is skipped on this pod.");
                return;
            }
            if (tcContext.getInitiator() instanceof SituationInstance && this.isContextUpdatedByDifferentPods(tcContext)) {
                log.info("Context was updated and expiration time for this context is changed on another pod before this expire event is got. TerminateByTimeout process is skipped on this pod ({}).", (Object)tcContext.getPodName());
                return;
            }
            log.info("TerminateByTimeout process is started for context {}", tcContext.getID());
            ExecutionServices.getTCContextService().terminateByTimeout(tcContext);
            log.info("TerminateByTimeout process is finished for context {}", tcContext.getID());
        }
        catch (Exception e) {
            log.error("Error while trying to terminate tc context by timeout", (Throwable)e);
        }
        finally {
            MDC.clear();
        }
    }

    private boolean isContextCreatedOnThisPod(@NotNull TcContext tcContext) {
        return Strings.isNotEmpty((CharSequence)tcContext.getPodName()) && tcContext.getPodName().equals(Config.getConfig().getRunningHostname());
    }

    private boolean isContextUpdatedByDifferentPods(TcContext tcContext) {
        long expirationTime = CacheServices.getTcContextCacheService().getExpirationTime(tcContext);
        return expirationTime != 0L && expirationTime >= System.currentTimeMillis();
    }
}

