/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BoundContextsCacheService {
    private static final Logger log = LoggerFactory.getLogger(BoundContextsCacheService.class);
    @Autowired
    BoundContextsCacheService boundContextsCacheService;
    private HazelcastInstance hazelcastClient;

    @Autowired
    public void setHazelcastClient(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    public void bind(TcContext tcContext) {
        for (String key : tcContext.getBindingKeys()) {
            this.boundContextsCacheService.set(key, tcContext);
        }
    }

    public boolean bind(String key, TcContext context) {
        if (context.getBindingKeys().add(key)) {
            this.boundContextsCacheService.set(key, context);
            return true;
        }
        return false;
    }

    public void unbind(TcContext tcContext) {
        String prefix = this.getPrefix(tcContext, "unbind");
        for (String key : tcContext.getBindingKeys()) {
            this.boundContextsCacheService.evict(prefix + key);
        }
    }

    public TcContext findByKey(String key, BigInteger projectId, UUID projectUuid) {
        return this.findByKey(key, true, projectId, projectUuid);
    }

    public TcContext findByKey(String key, boolean createIfNotFound, BigInteger projectId, @NotNull UUID projectUuid) {
        String keyPrefix = projectUuid.toString() + '/';
        Object tcContextId = this.boundContextsCacheService.getBoundContextsCache().get((Object)(keyPrefix + key));
        if (Objects.isNull(tcContextId)) {
            log.debug("Context id not found by key {} in {} cache for project {}. createIfNotFound = {}", new Object[]{key, "ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY", projectUuid, createIfNotFound});
            return createIfNotFound ? this.boundContextsCacheService.createByKey(key, false, projectId, projectUuid) : null;
        }
        TcContext tcContext = CacheServices.getTcContextCacheService().getById(tcContextId);
        if (Objects.isNull(tcContext)) {
            log.debug("Context not found by contextId {} in {} cache for project {}. createIfNotFound = {}", new Object[]{tcContextId, "ATP_ITF_TC_CONTEXTS", projectUuid, createIfNotFound});
            return createIfNotFound ? this.boundContextsCacheService.createByKey(key, false, projectId, projectUuid) : null;
        }
        return tcContext;
    }

    public TcContext findByKeys(String[] keys, BigInteger projectId, UUID projectUuid) {
        TcContext context;
        Arrays.sort(keys);
        for (String key : keys) {
            context = this.boundContextsCacheService.findByKey(key, false, projectId, projectUuid);
            if (context == null) continue;
            log.debug("Context is found by key {}", (Object)key);
            return context;
        }
        log.info("No context by keys {} found, will be created...", (Object)Arrays.toString(keys));
        context = this.boundContextsCacheService.createByKeys(keys, false, projectId, projectUuid);
        return context;
    }

    public TcContext createByKey(String key, boolean isStub, BigInteger projectId, UUID projectUuid) {
        TcContext context = ExecutionServices.getTCContextService().createInMemory(projectId, projectUuid);
        this.boundContextsCacheService.addIfNotBlank(context, key, isStub);
        log.info("A new context is created with key {} (prefix {}). isStub == {}", new Object[]{key, projectUuid, isStub});
        return context;
    }

    public TcContext createByKeys(String[] keys, boolean isStub, BigInteger projectId, UUID projectUuid) {
        TcContext context = ExecutionServices.getTCContextService().createInMemory(projectId, projectUuid);
        for (String key : keys) {
            this.boundContextsCacheService.addIfNotBlank(context, key, isStub);
        }
        log.info("A new context {} is created with keys {}", context.getID(), (Object)Arrays.toString(keys));
        return context;
    }

    private void set(String key, TcContext context) {
        String keyPrefix = this.getPrefix(context, "set");
        this.boundContextsCacheService.getBoundContextsCache().set((Object)(keyPrefix + key), context.getID());
        log.debug("Key {} was set to {} cache", (Object)(keyPrefix + key), (Object)"ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY");
        CacheServices.getTcContextCacheService().set(context, false);
    }

    private void evict(String key) {
        this.boundContextsCacheService.getBoundContextsCache().evict((Object)key);
        log.info("Key {} was unbind from {} cache", (Object)key, (Object)"ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY");
    }

    private IMap<Object, Object> getBoundContextsCache() {
        return this.hazelcastClient.getMap("ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY");
    }

    private void addIfNotBlank(TcContext context, String key, boolean isStub) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            context.getBindingKeys().add(key);
            if (!isStub) {
                this.boundContextsCacheService.set(key, context);
            }
        }
    }

    private String getPrefix(@NotNull TcContext context, String action) {
        UUID projectUuid = context.getProjectUuid();
        if (Objects.nonNull(projectUuid)) {
            return projectUuid.toString() + '/';
        }
        throw new IllegalArgumentException(String.format("Can't %s TcContext to/from %s cache. Key prefix (projectUuid) is null for TcContext %s ", action, "ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY", context.getID()));
    }
}

