/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextCallChainSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallchainSubscriberCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallchainSubscriberCacheService.class);
    private static final LoadingCache<Object, List<NextCallChainSubscriber>> TC_CONTEXT_SUBSCRIBERS_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Object, List<NextCallChainSubscriber>>(){

        public List<NextCallChainSubscriber> load(@Nonnull Object id) {
            return new ArrayList<NextCallChainSubscriber>();
        }
    });

    public void cleanUp() {
        TC_CONTEXT_SUBSCRIBERS_CACHE.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubscriber(Object subscriber) {
        if (subscriber instanceof NextCallChainSubscriber) {
            Object tcId;
            Object object = tcId = ((NextCallChainSubscriber)subscriber).getInstance().getContext().tc().getID();
            synchronized (object) {
                try {
                    ((List)TC_CONTEXT_SUBSCRIBERS_CACHE.get(tcId)).add((NextCallChainSubscriber)subscriber);
                }
                catch (ExecutionException e) {
                    LOGGER.error("Exception adding {} for tcId {}", new Object[]{subscriber, tcId, e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSubscriber(Object subscriber) {
        if (subscriber instanceof NextCallChainSubscriber) {
            Object tcId;
            Object object = tcId = ((NextCallChainSubscriber)subscriber).getInstance().getContext().tc().getID();
            synchronized (object) {
                List list = (List)TC_CONTEXT_SUBSCRIBERS_CACHE.getIfPresent(tcId);
                if (list != null) {
                    list.remove((NextCallChainSubscriber)subscriber);
                    if (list.isEmpty()) {
                        TC_CONTEXT_SUBSCRIBERS_CACHE.invalidate(tcId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NextCallChainSubscriber> unregisterAllSubscribers(Object tcId) {
        Object object = tcId;
        synchronized (object) {
            List list = (List)TC_CONTEXT_SUBSCRIBERS_CACHE.getIfPresent(tcId);
            TC_CONTEXT_SUBSCRIBERS_CACHE.invalidate(tcId);
            return list;
        }
    }
}

