/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PendingDataContextsCacheService {
    private static final Logger log = LoggerFactory.getLogger(PendingDataContextsCacheService.class);
    @Autowired
    PendingDataContextsCacheService pendingDataContextsCacheService;
    private HazelcastInstance hazelcastClient;

    @Autowired
    public void setHazelcastClient(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(TcContext tcContext, String key) {
        Object locObject;
        Object contextId = tcContext.getID();
        Object object = locObject = MonitorManager.getInstance().get("$id=" + contextId);
        synchronized (object) {
            Map<Object, TcContext> pendingContext = this.pendingDataContextsCacheService.getContextById(contextId);
            pendingContext.put(key, tcContext);
            this.pendingDataContextsCacheService.set(contextId, pendingContext);
        }
    }

    public Map<Object, TcContext> getContextById(Object contextId) {
        Map map = (Map)this.getPendingDataContexts().get(contextId);
        return map == null ? new HashMap() : map;
    }

    public void clearPendingDataContext(Object contextId) {
        this.getPendingDataContexts().evict(contextId);
    }

    private void set(Object contextId, Map<Object, TcContext> pendingDataContext) {
        this.getPendingDataContexts().set(contextId, pendingDataContext, 3L, TimeUnit.MINUTES);
    }

    private IMap<Object, Map<Object, TcContext>> getPendingDataContexts() {
        return this.hazelcastClient.getMap("ATP_ITF_PENDING_DATA_CONTEXTS");
    }
}

