/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.template;

import java.beans.ConstructorProperties;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

@Configuration
public class QueueJmsTemplateConfiguration {
    private final MessageConverter jacksonJmsMessageConverter;
    @Value(value="${message-broker.executor-stubs-outgoing-response.message-time-to-live}")
    private int outgoingResponseForStubsQueueMessagesTimeToLive;
    @Value(value="${message-broker.reports.message-time-to-live}")
    private int reportingQueueMessagesTimeToLive;

    @Bean
    public AtpJmsTemplate queueJmsTemplate(AtpJmsTemplate queueJmsTemplateInstance) {
        queueJmsTemplateInstance.setMessageConverter(this.jacksonJmsMessageConverter);
        queueJmsTemplateInstance.setPubSubDomain(false);
        ((JmsTemplate)queueJmsTemplateInstance).setExplicitQosEnabled(true);
        ((JmsTemplate)queueJmsTemplateInstance).setTimeToLive((long)this.outgoingResponseForStubsQueueMessagesTimeToLive);
        return queueJmsTemplateInstance;
    }

    @Bean
    public AtpJmsTemplate reportsQueueJmsTemplate(AtpJmsTemplate reportsQueueJmsTemplateInstance) {
        reportsQueueJmsTemplateInstance.setPubSubDomain(false);
        ((JmsTemplate)reportsQueueJmsTemplateInstance).setExplicitQosEnabled(true);
        ((JmsTemplate)reportsQueueJmsTemplateInstance).setTimeToLive((long)this.reportingQueueMessagesTimeToLive);
        return reportsQueueJmsTemplateInstance;
    }

    @ConstructorProperties(value={"jacksonJmsMessageConverter"})
    public QueueJmsTemplateConfiguration(MessageConverter jacksonJmsMessageConverter) {
        this.jacksonJmsMessageConverter = jacksonJmsMessageConverter;
    }
}

