/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.template.instance;

import java.beans.ConstructorProperties;
import javax.jms.ConnectionFactory;
import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.executor.objects.jms.DefaultJmsTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"atp.multi-tenancy.enabled"}, havingValue="false", matchIfMissing=true)
public class DefaultJmsTemplateInstancesConfiguration {
    private final ConnectionFactory defaultActiveMqConnectionFactory;
    private final ConnectionFactory reportsActiveMQConnectionFactory;
    private final ConnectionFactory reportsPooledConnectionFactory;

    @Bean
    public DefaultJmsTemplate topicJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public DefaultJmsTemplate queueJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public DefaultJmsTemplate endSituationsTopicJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public DefaultJmsTemplate reportsQueueJmsTemplateInstance() {
        return this.initDefaultJmsTemplate(this.reportsPooledConnectionFactory);
    }

    @NotNull
    private DefaultJmsTemplate initDefaultJmsTemplate(ConnectionFactory connectionFactory) {
        DefaultJmsTemplate defaultJmsTemplate = new DefaultJmsTemplate();
        defaultJmsTemplate.setConnectionFactory(connectionFactory);
        return defaultJmsTemplate;
    }

    @ConstructorProperties(value={"defaultActiveMqConnectionFactory", "reportsActiveMQConnectionFactory", "reportsPooledConnectionFactory"})
    public DefaultJmsTemplateInstancesConfiguration(ConnectionFactory defaultActiveMqConnectionFactory, ConnectionFactory reportsActiveMQConnectionFactory, ConnectionFactory reportsPooledConnectionFactory) {
        this.defaultActiveMqConnectionFactory = defaultActiveMqConnectionFactory;
        this.reportsActiveMQConnectionFactory = reportsActiveMQConnectionFactory;
        this.reportsPooledConnectionFactory = reportsPooledConnectionFactory;
    }
}

