/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.template.instance;

import java.beans.ConstructorProperties;
import javax.jms.ConnectionFactory;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.multitenancy.interceptor.jms.MultiTenantJmsTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"atp.multi-tenancy.enabled"}, havingValue="true")
public class MultiTenantJmsTemplateInstancesConfiguration {
    private final ConnectionFactory defaultActiveMqConnectionFactory;
    private final ConnectionFactory reportsActiveMQConnectionFactory;
    private final ConnectionFactory reportsPooledConnectionFactory;

    @Bean
    public MultiTenantJmsTemplate topicJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public MultiTenantJmsTemplate queueJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public MultiTenantJmsTemplate endSituationsTopicJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.defaultActiveMqConnectionFactory);
    }

    @Bean
    public MultiTenantJmsTemplate reportsQueueJmsTemplateInstance() {
        return this.initMultiTenantJmsTemplate(this.reportsPooledConnectionFactory);
    }

    @NotNull
    private MultiTenantJmsTemplate initMultiTenantJmsTemplate(ConnectionFactory connectionFactory) {
        MultiTenantJmsTemplate multiTenantJmsTemplate = new MultiTenantJmsTemplate();
        multiTenantJmsTemplate.setConnectionFactory(connectionFactory);
        return multiTenantJmsTemplate;
    }

    @ConstructorProperties(value={"defaultActiveMqConnectionFactory", "reportsActiveMQConnectionFactory", "reportsPooledConnectionFactory"})
    public MultiTenantJmsTemplateInstancesConfiguration(ConnectionFactory defaultActiveMqConnectionFactory, ConnectionFactory reportsActiveMQConnectionFactory, ConnectionFactory reportsPooledConnectionFactory) {
        this.defaultActiveMqConnectionFactory = defaultActiveMqConnectionFactory;
        this.reportsActiveMQConnectionFactory = reportsActiveMQConnectionFactory;
        this.reportsPooledConnectionFactory = reportsPooledConnectionFactory;
    }
}

