/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.event.trigger;

import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.util.constants.TriggerState;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.executor.event.trigger.IEventTriggerSwitcher;

public abstract class EventTriggerSwitcher
implements IEventTriggerSwitcher {
    @Override
    public void apply(EventTrigger eventTrigger) throws TriggerException {
        if (eventTrigger.getState().isOn()) {
            try {
                this._deactivate(eventTrigger);
                this._activate(eventTrigger);
            }
            catch (Exception e) {
                throw new TriggerException((Throwable)e);
            }
        }
    }

    @Override
    public void activate(EventTrigger eventTrigger) throws TriggerException {
        try {
            eventTrigger.setState(TriggerState.STARTING);
            this._activate(eventTrigger);
            eventTrigger.setState(TriggerState.ACTIVE);
        }
        catch (Throwable e) {
            eventTrigger.setState(TriggerState.ERROR);
            eventTrigger.setException(e);
            throw new TriggerException(String.format("Error while starting trigger %s", this), e);
        }
    }

    @Override
    public void deactivate(EventTrigger eventTrigger) throws TriggerException {
        try {
            eventTrigger.setState(TriggerState.SHUTTING_DOWN);
            this._deactivate(eventTrigger);
            eventTrigger.setState(TriggerState.INACTIVE);
        }
        catch (Throwable e) {
            eventTrigger.setState(TriggerState.ERROR);
            eventTrigger.setException(e);
            throw new TriggerException(String.format("Error while stopping trigger %s", this), e);
        }
    }

    protected abstract void _activate(EventTrigger var1) throws Exception;

    protected abstract void _deactivate(EventTrigger var1) throws Exception;
}

