/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.event.trigger;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.system.stub.EventTrigger;
import org.qubership.automation.itf.core.model.jpa.system.stub.Listener;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.util.config.Config;
import org.qubership.automation.itf.core.util.exception.TriggerException;
import org.qubership.automation.itf.core.util.holder.EventTriggerHolder;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.event.trigger.EventTriggerService;
import org.qubership.automation.itf.executor.event.trigger.EventTriggerSwitcher;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SituationEventTriggerSwitcher
extends EventTriggerSwitcher {
    private static final String RUNNING_HOSTNAME = Config.getConfig().getRunningHostname();
    private transient Listener listener;
    private EventBusProvider eventBusProvider;

    @Autowired
    public SituationEventTriggerSwitcher(EventBusProvider eventBusProvider) {
        this.eventBusProvider = eventBusProvider;
    }

    @Override
    protected void _activate(EventTrigger eventTrigger) throws TriggerException {
        SituationEventTrigger situationEventTrigger = (SituationEventTrigger)eventTrigger;
        if (situationEventTrigger.getSituation() == null) {
            throw new TriggerException(String.format("Situation for trigger is not specified. Situation trigger container is: %s", eventTrigger.getParent().toString()));
        }
        if (situationEventTrigger.getOn() == null) {
            throw new TriggerException(String.format("On condition is not specified. Situation trigger container is: %s", eventTrigger.getParent().toString()));
        }
        this.deactivateOldThenActivateNew(situationEventTrigger.getID(), situationEventTrigger.getOn(), situationEventTrigger.getSituation().getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deactivate(EventTrigger eventTrigger) {
        Object object = eventTrigger.getID();
        synchronized (object) {
            this.listener = EventTriggerHolder.getInstance().get(eventTrigger.getID());
            if (this.listener != null) {
                boolean isStartListener = this.listener instanceof StartListener;
                if (!isStartListener) {
                    this.eventBusProvider.unregisterNormal(this.listener);
                }
                EventTriggerHolder.getInstance().remove(this.listener, isStartListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateOldThenActivateNew(Object triggerId, SituationEventTrigger.On onEvent, Object situationId) throws TriggerException {
        Object object = triggerId;
        synchronized (object) {
            boolean isStartListener = false;
            if (SituationEventTrigger.On.FINISH.equals((Object)onEvent)) {
                this.listener = new EndListener(triggerId, situationId);
                Listener oldListener = EventTriggerHolder.getInstance().get(triggerId);
                if (oldListener != null) {
                    this.eventBusProvider.unregisterNormal(oldListener);
                    EventTriggerHolder.getInstance().remove(oldListener, false);
                }
                this.eventBusProvider.register(this.listener, EventBusProvider.Priority.NORMAL);
            } else if (SituationEventTrigger.On.START.equals((Object)onEvent)) {
                this.listener = new StartListener(triggerId, situationId);
                isStartListener = true;
                Listener oldListener = EventTriggerHolder.getInstance().get(triggerId);
                if (oldListener != null) {
                    EventTriggerHolder.getInstance().remove(oldListener, true);
                }
            }
            if (this.listener == null) {
                throw new TriggerException("Cannot activate situation trigger %s. Listener isn't initialized");
            }
            EventTriggerHolder.getInstance().add(this.listener, isStartListener);
        }
    }

    private static class EndListener
    implements Listener {
        final Object triggerId;
        private final Object situationId;

        private EndListener(Object triggerId, Object situationId) {
            this.triggerId = triggerId;
            this.situationId = situationId;
        }

        @Subscribe
        @AllowConcurrentEvents
        public void on(SituationEvent.Finish event) {
            if (this.situationId.equals(event.getSituationInstance().getStepContainer().getID()) && !event.isStopped() && event.getRunningHostname().equals(RUNNING_HOSTNAME)) {
                SituationEventTrigger eventTrigger = (SituationEventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).getById(this.triggerId);
                EventTriggerService.executeSituationBySituationEventTrigger((SituationEvent)event, eventTrigger);
            }
        }

        public Object getId() {
            return this.triggerId;
        }

        public Object getSituationId() {
            return this.situationId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndListener that = (EndListener)o;
            return this.triggerId.equals(that.triggerId) && this.situationId.equals(that.situationId);
        }

        public int hashCode() {
            return Objects.hash(this.triggerId, this.situationId);
        }
    }

    private static class StartListener
    implements Listener {
        final Object triggerId;
        private final Object situationId;

        private StartListener(Object triggerId, Object situationId) {
            this.triggerId = triggerId;
            this.situationId = situationId;
        }

        @Subscribe
        @AllowConcurrentEvents
        public void on(SituationEvent.Start event) {
            if (this.situationId.equals(event.getSituationInstance().getStepContainer().getID()) && !event.isStopped()) {
                SituationEventTrigger eventTrigger = (SituationEventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).getById(this.triggerId);
                EventTriggerService.executeSituationBySituationEventTrigger((SituationEvent)event, eventTrigger);
            }
        }

        public Object getId() {
            return this.triggerId;
        }

        public Object getSituationId() {
            return this.situationId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartListener that = (StartListener)o;
            return this.triggerId.equals(that.triggerId) && this.situationId.equals(that.situationId);
        }

        public int hashCode() {
            return Objects.hash(this.triggerId, this.situationId);
        }
    }
}

