/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.transports.holder;

import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.helper.ClassResolver;
import org.qubership.automation.itf.core.util.provider.MeansCommunication;
import org.qubership.automation.itf.core.util.transport.base.Transport;
import org.qubership.automation.itf.executor.transports.classloader.TransportClassLoader;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportHolder.class);
    private static final TransportHolder INSTANCE = new TransportHolder();
    private final Set<Transport> transports = Sets.newHashSetWithExpectedSize((int)20);
    private final Map<String, String> transportNames = new HashMap<String, String>();

    private TransportHolder() {
        this.deployTransports(false);
    }

    public static TransportHolder getInstance() {
        return INSTANCE;
    }

    public Set<Transport> getTransports() {
        return Collections.unmodifiableSet(this.transports);
    }

    public void redeploy() {
        this.deployTransports(true);
    }

    private void deployTransports(boolean isRedeploy) {
        HashSet subtypesOf = Sets.newHashSet();
        TransportClassLoader.getInstance().load(ApplicationConfig.env.getProperty("transport.folder"), ApplicationConfig.env.getProperty("transport.lib"));
        for (Map.Entry entry : TransportClassLoader.getInstance().getClassLoaderHolder().entrySet()) {
            subtypesOf.addAll(ClassResolver.getInstance().getSubtypesOf(Transport.class, new Reflections(new Object[]{"org.qubership", entry.getValue()})));
        }
        for (Class aClass : subtypesOf) {
            if (Modifier.isAbstract(aClass.getModifiers())) continue;
            try {
                if (isRedeploy && Objects.nonNull(this.checkAvailability(aClass.getName()))) continue;
                Transport transport = (Transport)aClass.newInstance();
                this.transports.add(transport);
                this.transportNames.put(aClass.getName(), transport.getShortName());
            }
            catch (Exception e) {
                LOGGER.error("Cannot instantiate transport {}", (Object)aClass, (Object)e);
            }
        }
    }

    public MeansCommunication checkAvailability(String typeName) {
        for (Transport transport : this.transports) {
            if (!transport.getClass().getName().equals(typeName)) continue;
            return transport;
        }
        return null;
    }

    public String getShortName(String typeName) {
        return this.transportNames.getOrDefault(typeName, "");
    }
}

