/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.monitoring.tasks.service;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.qubership.automation.itf.executor.cache.service.RunningScheduledTasksCacheService;
import org.qubership.automation.itf.monitoring.tasks.RunningScheduledTask;
import org.qubership.automation.itf.monitoring.tasks.ScheduledGlobalTaskKey;
import org.qubership.automation.itf.monitoring.tasks.ScheduledTaskSettings;
import org.qubership.automation.itf.monitoring.tasks.service.ScheduledTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultScheduledGlobalTaskService
implements ScheduledTaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultScheduledGlobalTaskService.class);
    private final ScheduledExecutorService scheduledExecutor;
    private final RunningScheduledTasksCacheService runningScheduledTasksCacheService;

    protected DefaultScheduledGlobalTaskService(ScheduledExecutorService scheduledExecutor, RunningScheduledTasksCacheService runningScheduledTasksCacheService) {
        this.scheduledExecutor = scheduledExecutor;
        this.runningScheduledTasksCacheService = runningScheduledTasksCacheService;
    }

    @Override
    public void scheduleTask() {
        ScheduledTaskSettings taskSettings = this.createScheduledTaskSettings();
        this.scheduleTaskIfPossible(taskSettings);
    }

    private void scheduleTaskIfPossible(ScheduledTaskSettings taskSettings) {
        if (!taskSettings.isSchedulingPossible()) {
            log.debug("Task {} can not be scheduled due to condition. Task will not run!", (Object)this.getTaskType());
        } else {
            this.scheduledExecutor.scheduleWithFixedDelay(this::runTaskIfNotAlreadyRunning, taskSettings.getInitialDelay(), taskSettings.getDelay(), taskSettings.getDelayTimeUnit());
            log.info("Task {} was scheduled with next settings: {}.", (Object)this.getTaskType(), (Object)taskSettings);
        }
    }

    private void runTaskIfNotAlreadyRunning() {
        ScheduledGlobalTaskKey taskKey = new ScheduledGlobalTaskKey(this.getTaskType());
        Optional<RunningScheduledTask> runningTask = this.runningScheduledTasksCacheService.findByScheduledTaskKey(taskKey);
        if (runningTask.isPresent()) {
            log.debug("Global task {} already running since {}. Duplicate task will not run!", (Object)this.getTaskType(), (Object)runningTask.get().getStartDate());
        } else {
            this.runningScheduledTasksCacheService.storeRunningTaskToCache(taskKey);
            this.runTask();
            this.runningScheduledTasksCacheService.evictRunningTaskFromCache(taskKey);
        }
    }

    protected abstract void runTask();

    protected abstract ScheduledTaskSettings createScheduledTaskSettings();
}

