/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.monitoring.tasks.service;

import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.cache.service.RunningScheduledTasksCacheService;
import org.qubership.automation.itf.monitoring.tasks.RunningScheduledTask;
import org.qubership.automation.itf.monitoring.tasks.ScheduledProjectTaskKey;
import org.qubership.automation.itf.monitoring.tasks.ScheduledTaskSettings;
import org.qubership.automation.itf.monitoring.tasks.service.ScheduledTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultScheduledProjectTaskService
implements ScheduledTaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultScheduledProjectTaskService.class);
    private final ScheduledExecutorService scheduledExecutor;
    private final RunningScheduledTasksCacheService runningScheduledTasksCacheService;

    protected DefaultScheduledProjectTaskService(ScheduledExecutorService scheduledExecutor, RunningScheduledTasksCacheService runningScheduledTasksCacheService) {
        this.scheduledExecutor = scheduledExecutor;
        this.runningScheduledTasksCacheService = runningScheduledTasksCacheService;
    }

    @Override
    public void scheduleTask() {
        CoreObjectManager.getInstance().getManager(StubProject.class).getAll().forEach(project -> {
            BigInteger projectId = (BigInteger)project.getID();
            ScheduledTaskSettings taskSettings = this.createScheduledTaskSettingsForProject(projectId);
            this.scheduleTaskIfPossible(taskSettings, projectId);
        });
    }

    private void scheduleTaskIfPossible(ScheduledTaskSettings taskSettings, BigInteger projectId) {
        if (!taskSettings.isSchedulingPossible()) {
            log.debug("Task {} for project {} can not be scheduled due to condition. Task will not run!", (Object)this.getTaskType(), (Object)projectId);
        } else {
            this.scheduledExecutor.scheduleWithFixedDelay(() -> this.runTaskIfNotAlreadyRunning(projectId), taskSettings.getInitialDelay(), taskSettings.getDelay(), taskSettings.getDelayTimeUnit());
            log.info("Task {} for project {} was scheduled with next settings: {}.", new Object[]{this.getTaskType(), projectId, taskSettings});
        }
    }

    private void runTaskIfNotAlreadyRunning(BigInteger projectId) {
        ScheduledProjectTaskKey taskKey = new ScheduledProjectTaskKey(this.getTaskType(), projectId);
        Optional<RunningScheduledTask> runningTask = this.runningScheduledTasksCacheService.findByScheduledTaskKey(taskKey);
        if (runningTask.isPresent()) {
            log.debug("Task {} already running for project {} since {}. Duplicate task will not run!", new Object[]{this.getTaskType(), projectId, runningTask.get().getStartDate()});
        } else {
            this.runningScheduledTasksCacheService.storeRunningTaskToCache(taskKey);
            this.runTaskForProject(projectId);
            this.runningScheduledTasksCacheService.evictRunningTaskFromCache(taskKey);
        }
    }

    protected abstract void runTaskForProject(BigInteger var1);

    protected abstract ScheduledTaskSettings createScheduledTaskSettingsForProject(BigInteger var1);
}

