/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.openapi.controllers;

import org.qubership.atp.environments.openapi.dto.ConnectionByCategoryDtoDto;
import org.qubership.atp.environments.openapi.dto.ConnectionDto;
import org.qubership.atp.environments.openapi.dto.ConnectionDtoDto;
import org.qubership.atp.environments.openapi.dto.ConnectionNameViewDto;
import java.util.List;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-08T09:59:24.634Z[Etc/UTC]")
@Validated
@Tag(name = "ConnectionController", description = "Connection Controller")
public interface ConnectionControllerApi {

    /**
     * POST /api/connections : create
     *
     * @param connectionDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createConnection",
        summary = "create",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/connections",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ConnectionDto> createConnection(
        @Parameter(name = "ConnectionDtoDto", description = "") @Valid @RequestBody(required = false) ConnectionDtoDto connectionDtoDto
    );


    /**
     * DELETE /api/connections/{connectionId} : delete
     *
     * @param connectionId connectionId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteConnection",
        summary = "delete",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/connections/{connectionId}"
    )
    ResponseEntity<Void> deleteConnection(
        @Parameter(name = "connectionId", description = "connectionId", required = true) @PathVariable("connectionId") UUID connectionId
    );


    /**
     * GET /api/connections/{connectionId} : getConnection
     *
     * @param connectionId connectionId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnection",
        summary = "getConnection",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/connections/{connectionId}",
        produces = { "application/json" }
    )
    ResponseEntity<ConnectionDto> getConnection(
        @Parameter(name = "connectionId", description = "connectionId", required = true) @PathVariable("connectionId") UUID connectionId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/connections/templates : getConnectionTemplates
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionTemplates",
        summary = "getConnectionTemplates",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/connections/templates",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionDto>> getConnectionTemplates(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/connections/templates/short : Getting connection templates in abbreviated form :{id:\&quot;\&quot;,name:\&quot;\&quot;}
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionTemplatesShort",
        summary = "Getting connection templates in abbreviated form :{id:\"\",name:\"\"}",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionNameViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/connections/templates/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionNameViewDto>> getConnectionTemplatesShort(
        
    );


    /**
     * GET /api/connections : getConnectionsAll
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionsAll",
        summary = "getConnectionsAll",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/connections",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionDto>> getConnectionsAll(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * POST /api/connections/getAllBy : getConnectionsAllBy
     *
     * @param full full (optional)
     * @param connectionByCategoryDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionsAllBy",
        summary = "getConnectionsAllBy",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/connections/getAllBy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<ConnectionDto>> getConnectionsAllBy(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full,
        @Parameter(name = "ConnectionByCategoryDtoDto", description = "") @Valid @RequestBody(required = false) ConnectionByCategoryDtoDto connectionByCategoryDtoDto
    );


    /**
     * PUT /api/connections : update
     *
     * @param connectionDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateConnection",
        summary = "update",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/connections",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ConnectionDto> updateConnection(
        @Parameter(name = "ConnectionDtoDto", description = "") @Valid @RequestBody(required = false) ConnectionDtoDto connectionDtoDto
    );


    /**
     * PUT /api/connections/parameters : updateParameters
     *
     * @param connectionDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateParameters",
        summary = "updateParameters",
        tags = { "connection-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/connections/parameters",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<ConnectionDto>> updateParameters(
        @Parameter(name = "ConnectionDtoDto", description = "") @Valid @RequestBody(required = false) List<ConnectionDtoDto> connectionDtoDto
    );

}
