/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.execution;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import javax.inject.Named;
import org.qubership.automation.itf.core.execution.DefaultExecutorServiceProvider;
import org.qubership.automation.itf.core.execution.ExecutorServiceProvider;
import org.qubership.automation.itf.core.util.config.Config;

public class ExecutorServiceProviderFactory {
    private static final int EXECUTOR_THREAD_POOL_SIZE = Integer.parseInt(Config.getConfig().getString("executor.thread.pool.size"));
    private static final int EXECUTOR_THREAD_POOL_CORE_SIZE = Integer.parseInt(Config.getConfig().getString("executor.thread.pool.core.size"));
    private static final int BACKGROUND_EXECUTOR_THREAD_POOL_SIZE = Integer.parseInt(Config.getConfig().getString("background.executor.thread.pool.size"));
    private static final Supplier<ExecutorServiceProvider> DEFAULT = () -> new DefaultExecutorServiceProvider(EXECUTOR_THREAD_POOL_CORE_SIZE, EXECUTOR_THREAD_POOL_SIZE, BACKGROUND_EXECUTOR_THREAD_POOL_SIZE);
    private static volatile ExecutorServiceProvider INSTANCE;

    @Inject
    protected ExecutorServiceProviderFactory(@Named(value="executionProvider") ExecutorServiceProvider provider) {
        ExecutorServiceProviderFactory.init(provider);
    }

    public static ExecutorServiceProvider get() {
        ExecutorServiceProviderFactory.init(DEFAULT);
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Supplier<ExecutorServiceProvider> instance) {
        if (INSTANCE != null) return;
        Class<ExecutorServiceProviderFactory> clazz = ExecutorServiceProviderFactory.class;
        synchronized (ExecutorServiceProviderFactory.class) {
            if (INSTANCE != null) return;
            INSTANCE = (ExecutorServiceProvider)instance.get();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void init(ExecutorServiceProvider instance) {
        ExecutorServiceProviderFactory.init((Supplier<ExecutorServiceProvider>)Suppliers.ofInstance((Object)instance));
    }
}

