/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import org.jetbrains.annotations.NotNull;
import org.qubership.automation.itf.core.model.event.AbstractEvent;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.provider.EventBusServiceProvider;
import org.slf4j.LoggerFactory;

public abstract class AbstractChainSubscriber<T extends AbstractEvent> {
    private final String id;
    private String parentId;

    protected AbstractChainSubscriber(String id, String parentId) {
        this.id = id;
        this.parentId = parentId;
    }

    public void handleEvent(T event) {
        try {
            if (event.getID().equals(this.id)) {
                this.onEvent(event);
            } else {
                this.unregisterIfExpired();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Failed processing event " + event, (Throwable)e);
            this.destroy();
        }
    }

    void sendFailEventToTheSubscriber(String subscriberId, Exception exception) {
        EventBusServiceProvider.getStaticReference().post((Event)new NextCallChainEvent.Fail(subscriberId, exception));
    }

    protected abstract void unregisterIfExpired();

    protected abstract void onEvent(T var1) throws Exception;

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    protected void destroy() {
        EventBusServiceProvider.getStaticReference().unregister(this);
    }

    protected <Subscriber extends AbstractChainSubscriber, Event extends AbstractEvent> void subscribeAndPostEvent(Subscriber stepSubscriber, Event stepEvent) {
        EventBusServiceProvider.getStaticReference().register(stepSubscriber, EventBusProvider.Priority.HIGH);
        EventBusServiceProvider.getStaticReference().post((Event)stepEvent);
    }

    @NotNull
    protected abstract String getTenantId(T var1);
}

