/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.report;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.ContextManager;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.event.CallChainEvent;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.event.StepEvent;
import org.qubership.automation.itf.core.model.event.TcContextEvent;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.report.ReportIntegration;
import org.qubership.automation.itf.core.report.RunSubscriberInterface;
import org.qubership.automation.itf.core.report.producer.ReportWorker;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.manager.MonitorManager;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LoggerSubscriber {
    public static final Logger LOGGER = LoggerFactory.getLogger(LoggerSubscriber.class);
    public static final String CLIENT_IP = "clientIP";
    @Value(value="${atp.multi-tenancy.enabled}")
    private Boolean multiTenancyEnabled;
    private ReportWorker worker;
    private RunSubscriberInterface runSubscriber;
    private ReportLinkCollector reportLinkCollector;
    private EventBusProvider eventBusProvider;

    @Autowired
    public LoggerSubscriber(ReportWorker worker, RunSubscriberInterface runSubscriber, ReportLinkCollector reportLinkCollector, EventBusProvider eventBusProvider) {
        this.worker = worker;
        this.runSubscriber = runSubscriber;
        this.reportLinkCollector = reportLinkCollector;
        this.eventBusProvider = eventBusProvider;
    }

    @PostConstruct
    public void init() {
        this.eventBusProvider.register(this, EventBusProvider.Priority.HIGH);
    }

    @PreDestroy
    public void destroy() {
        this.eventBusProvider.unregister(this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextStart(TcContextEvent.Start event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        this.fillReportLinks(event.getContext(), false);
        if (event.getContext().isNeedToReportToAtp()) {
            Report.startRun((TcContext)event.getContext());
        }
        if (event.getContext().isNeedToReportToItf()) {
            this.worker.submit((Storable)event.getContext(), event.getDate(), event.getContext().getProjectId(), projectUuid);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextUpdateInfo(TcContextEvent.UpdateInfo event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        if (event.getContext().isNeedToReportToItf()) {
            this.worker.submit((Storable)event.getContext(), event.getDate(), event.getContext().getProjectId(), projectUuid);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextFail(TcContextEvent.Fail event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        this.logContextEvent((TcContextEvent)event, Status.FAILED, projectUuid);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextFinish(TcContextEvent.Finish event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        this.logContextEvent((TcContextEvent)event, Status.PASSED, projectUuid);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextStop(TcContextEvent.Stop event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        this.logContextEvent((TcContextEvent)event, Status.STOPPED, projectUuid);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onContextPaused(TcContextEvent.Pause event) {
        String projectUuid = event.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        if (event.getContext().isNeedToReportToItf()) {
            this.worker.submit((Storable)event.getContext(), event.getDate(), event.getContext().getProjectId(), projectUuid);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onChainStart(CallChainEvent.Start event) {
        CallChainInstance chainInstance = event.getInstance();
        if (chainInstance.getContext().tc().isNeedToReportToAtp()) {
            Report.openSection((AbstractInstance)chainInstance, (String)("Call chain [" + chainInstance.getStepContainer().getName() + "]"));
            if (chainInstance.stepsIsDisabled()) {
                Report.warn((AbstractInstance)chainInstance, (String)("Steps in Call Chain [" + chainInstance.getStepContainer().getName() + "] are disabled"), (String)"All steps are disabled");
            } else {
                Report.reportCallChainInfo((CallChainInstance)chainInstance);
            }
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onChainFinish(CallChainEvent.Finish event) {
        CallChainInstance chainInstance = this.submitCallChainInstance(event.getInstance(), "Finish chain ", event.getDate());
        if (chainInstance.getContext().tc().isNeedToReportToAtp() && chainInstance != chainInstance.getContext().getTC().getInitiator()) {
            Report.closeSection((AbstractInstance)chainInstance);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onChainTerminate(CallChainEvent.Terminate event) {
        CallChainInstance chainInstance = this.submitCallChainInstance(event.getInstance(), "Terminate chain ", event.getDate());
        if (chainInstance.getContext().tc().isNeedToReportToAtp()) {
            Report.terminated((AbstractInstance)chainInstance, (String)("Call Chain [" + chainInstance.getStepContainer().getName() + "] Terminated"), (String)"Execution of chain terminated", (Throwable)chainInstance.getError());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onSituationStart(SituationEvent.Start event) {
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onSituationFinish(SituationEvent.Finish event) {
        SituationInstance situationInstance = this.submitSituationInstance(event.getSituationInstance(), "Finish situation ", event.getDate());
        if (situationInstance.getContext().tc().isNeedToReportToAtp()) {
            Report.closeSection((AbstractInstance)situationInstance);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onSituationTerminate(SituationEvent.Terminate event) {
        SituationInstance situationInstance = this.submitSituationInstance(event.getSituationInstance(), "Terminate situation ", event.getDate());
        if (situationInstance.getContext().tc().isNeedToReportToAtp()) {
            Report.terminated((AbstractInstance)situationInstance, (String)("Situation [" + situationInstance.getName() + "] Terminated"), (String)"Execution situation terminated", (Throwable)situationInstance.getError());
            Report.closeSection((AbstractInstance)situationInstance);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onStepFinish(StepEvent.Finish event) {
        StepInstance stepInstance = this.submitStepInstance(event.getStepInstance(), "Finish step ", event.getDate());
        this.logStepInfo(stepInstance, "%s");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onStepSkip(StepEvent.Skip event) {
        StepInstance stepInstance = this.submitStepInstance(event.getStepInstance(), "Skip step ", event.getDate());
        this.logStepInfo(stepInstance, "[%s] Skipped");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onStepTerminate(StepEvent.Terminate event) {
        StepInstance stepInstance = this.submitStepInstance(event.getStepInstance(), "Terminate step ", event.getDate());
        if (stepInstance.getContext().tc().isNeedToReportToAtp() && !stepInstance.getContext().tc().getStartedFrom().equals((Object)StartedFrom.RAM2)) {
            Report.error((AbstractInstance)stepInstance, (String)("[" + stepInstance.getStep().getName() + "] Terminated"), (SpContext)stepInstance.getContext().sp(), (Throwable)stepInstance.getError());
            Report.closeSection((AbstractInstance)stepInstance.getParent());
        }
    }

    private void logContextEvent(TcContextEvent event, Status status, String tenantId) {
        TcContext tcContext = event.getContext();
        if (!Status.STOPPED.equals((Object)status) && !Status.FAILED_BY_TIMEOUT.equals((Object)tcContext.getStatus())) {
            try {
                ReportIntegration.getInstance().runAndReportAfterIntegrations(tcContext);
            }
            catch (Throwable ex) {
                LOGGER.error("Context {} is {}; then integration error is thrown: {}", new Object[]{tcContext.getID(), status.toString(), ex.getMessage()});
            }
        }
        try {
            if (tcContext.isNeedToReportToItf()) {
                this.worker.submit((Storable)tcContext, event.getDate(), tcContext.getProjectId(), tenantId);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Context {} is {}; then inner reporting error is thrown: {}", new Object[]{tcContext.getID(), status.toString(), ex.getMessage()});
        }
        ExecutionServices.getTCContextService().notifyATP(tcContext);
        if (tcContext.isNeedToReportToAtp()) {
            LOGGER.debug("Context is {}: {}", (Object)status.toString(), (Object)event.getContext());
            Report.stopRun((InstanceContext)InstanceContext.from((TcContext)tcContext, (SpContext)new SpContext()), (Status)status);
        }
        if (!tcContext.getStartedFrom().equals((Object)StartedFrom.RAM2)) {
            CacheServices.getTcContextCacheService().evict(tcContext);
        }
    }

    private void logStepInfo(StepInstance stepInstance, String format) {
        if (stepInstance.getContext().tc().isNeedToReportToAtp()) {
            Report.info((AbstractInstance)stepInstance, (String)String.format(format, stepInstance.getStep().getName()), (SpContext)stepInstance.getContext().sp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(String message, TcContext tcContext) {
        Object object;
        Object object2 = object = MonitorManager.getInstance().get(tcContext.getID().toString());
        synchronized (object2) {
            try {
                object.wait();
                TcContext context = (TcContext)((ContextManager)CoreObjectManager.getInstance().getSpecialManager(TcContext.class, ContextManager.class)).getById(tcContext.getID());
                if (context.containsKey((Object)CLIENT_IP)) {
                    this.runSubscriber.send(message, context.get((Object)CLIENT_IP).toString());
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed while waiting notification", (Throwable)e);
            }
        }
    }

    private void fillReportLinks(TcContext context, boolean standalone) {
        try {
            AbstractContainerInstance initiator;
            Map reportLinks = context.getReportLinks();
            if (context.isNeedToReportToItf()) {
                reportLinks.put("ITF context link", this.reportLinkCollector.getLinkToObject(context.getProjectId(), context.getProjectUuid(), context.getID(), "#/context/", standalone));
            }
            if ((initiator = context.getInitiator()) instanceof SituationInstance) {
                if (((SituationInstance)initiator).getSystemId() != null) {
                    reportLinks.put("System link", this.reportLinkCollector.getLinkToObject(context.getProjectId(), context.getProjectUuid(), (Object)((SituationInstance)initiator).getSystemId(), "#/system/", standalone));
                }
            } else if (initiator instanceof CallChainInstance) {
                reportLinks.put("Callchain link", this.reportLinkCollector.getLinkToObject(context.getProjectId(), context.getProjectUuid(), (Object)((CallChainInstance)initiator).getTestCaseId(), "#/callchain/", standalone));
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Starting context {}; error while collecting of report links: {}", context.getID(), (Object)ex.getMessage());
        }
    }

    @NotNull
    private CallChainInstance submitCallChainInstance(CallChainInstance callChainInstance, String logMessage, Date eventDate) {
        String projectUuid = callChainInstance.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        LOGGER.debug(logMessage + callChainInstance);
        if (callChainInstance.getContext().tc().isNeedToReportToItf()) {
            this.worker.submit((Storable)callChainInstance, eventDate, callChainInstance.getContext().tc().getProjectId(), projectUuid);
        }
        return callChainInstance;
    }

    @NotNull
    private StepInstance submitStepInstance(StepInstance stepInstance, String logMessage, Date eventDate) {
        String projectUuid = stepInstance.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        LOGGER.debug(logMessage + stepInstance);
        if (stepInstance.getContext().tc().isNeedToReportToItf()) {
            this.worker.submit((Storable)stepInstance, eventDate, stepInstance.getContext().tc().getProjectId(), projectUuid);
        }
        return stepInstance;
    }

    private SituationInstance submitSituationInstance(SituationInstance situationInstance, String logMessage, Date eventDate) {
        String projectUuid = situationInstance.getContext().getProjectUuid().toString();
        if (this.multiTenancyEnabled.booleanValue()) {
            TenantContext.setTenantInfo((String)projectUuid);
        }
        LOGGER.debug(logMessage + situationInstance);
        if (situationInstance.getContext().tc().isNeedToReportToItf()) {
            this.worker.submit((Storable)situationInstance, eventDate, situationInstance.getContext().tc().getProjectId(), projectUuid);
        }
        return situationInstance;
    }
}

