/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.event.trigger;

import java.util.List;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTriggerService {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventTriggerService.class);

    protected static void executeSituationBySituationEventTrigger(SituationEvent event, SituationEventTrigger situationEventTrigger) {
        Situation parent = situationEventTrigger.getParent();
        SituationInstance situationInstance = event.getSituationInstance();
        List conditionParameters = situationEventTrigger.getConditionParameters();
        InstanceContext instanceContext = situationInstance.getContext();
        LOGGER.info("Event received by situation [{}], processing under {} {}...", new Object[]{situationInstance.getStepContainer(), parent == null ? "" : parent.getClass().getSimpleName(), parent == null ? "" : parent.getName()});
        if (!instanceContext.tc().isFinished()) {
            if (conditionParameters == null || conditionParameters.isEmpty() || ConditionsHelper.isApplicable((JsonContext)instanceContext, (List)conditionParameters)) {
                if (conditionParameters == null || conditionParameters.isEmpty()) {
                    LOGGER.info("Condition is empty, applicable anyway");
                } else {
                    LOGGER.info("Conditions are applicable, handling under {} {}...", (Object)(parent == null ? "" : parent.getClass().getSimpleName()), (Object)(parent == null ? "" : parent.getName()));
                }
                if (parent != null) {
                    try {
                        ExecutionServices.getSituationExecutorService().execute(parent, instanceContext);
                    }
                    catch (Exception e) {
                        LOGGER.error(String.format("Error executing situation %s", parent), (Throwable)e);
                    }
                } else {
                    LOGGER.warn("Run situation handler was called, but situation to execute is null");
                }
            } else {
                LOGGER.info("Condition property is not applicable, skip under {} {}", (Object)(parent == null ? "" : parent.getClass().getSimpleName()), (Object)(parent == null ? "" : parent.getName()));
            }
        } else {
            LOGGER.info("Event was rejected due to context '{}' is closed", (Object)instanceContext.tc().getName());
        }
    }
}

