/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.provider;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.executor.cache.service.impl.CallchainSubscriberCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventBusProvider {
    private static final Logger BUS_PROVIDER_LOGGER = LoggerFactory.getLogger(EventBusProvider.class);
    private final EventBus normalPriorityEventBus = new EventBus((SubscriberExceptionHandler)new LoggingSubscriberExceptionHandler("Normal priority bus"));
    private final EventBus highPriorityEventBus = new EventBus((SubscriberExceptionHandler)new LoggingSubscriberExceptionHandler("High priority bus"));
    private CallchainSubscriberCacheService callchainSubscriberCacheService;

    @Autowired
    public EventBusProvider(CallchainSubscriberCacheService callchainSubscriberCacheService) {
        this.callchainSubscriberCacheService = callchainSubscriberCacheService;
    }

    public void post(Event event) {
        this.highPriorityEventBus.post((Object)event);
        this.normalPriorityEventBus.post((Object)event);
    }

    public void register(Object subscriber) {
        this.register(subscriber, Priority.NORMAL);
    }

    public void register(Object subscriber, Priority priority) {
        if (Priority.HIGH.equals((Object)priority)) {
            this.highPriorityEventBus.register(subscriber);
        } else {
            this.normalPriorityEventBus.register(subscriber);
        }
        this.callchainSubscriberCacheService.registerSubscriber(subscriber);
    }

    public void unregister(Object subscriber) {
        this.callchainSubscriberCacheService.unregisterSubscriber(subscriber);
        try {
            this.highPriorityEventBus.unregister(subscriber);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.normalPriorityEventBus.unregister(subscriber);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterNormal(Object subscriber) {
        this.callchainSubscriberCacheService.unregisterSubscriber(subscriber);
        try {
            this.normalPriorityEventBus.unregister(subscriber);
        }
        catch (Exception e) {
            BUS_PROVIDER_LOGGER.warn("Failed unregistering of subscriber {}", subscriber, (Object)e);
        }
    }

    public EventBus getBus(String priority) {
        return Priority.HIGH.toString().equals(priority) ? this.highPriorityEventBus : this.normalPriorityEventBus;
    }

    public EventBus getBus(Priority priority) {
        return Priority.HIGH.equals((Object)priority) ? this.highPriorityEventBus : this.normalPriorityEventBus;
    }

    private static final class LoggingSubscriberExceptionHandler
    implements SubscriberExceptionHandler {
        private String name;

        LoggingSubscriberExceptionHandler(String name) {
            this.name = name;
        }

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            String exceptionMessage = StringUtils.isBlank((CharSequence)exception.getMessage()) ? exception.toString() : exception.getMessage();
            exceptionMessage = exceptionMessage + (exception.getCause() != null ? "\nCaused by: " + exception.getCause().toString() : "\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)exception));
            BUS_PROVIDER_LOGGER.error("Could not dispatch event {}; {} to {} at bus {}: Error: {}", new Object[]{context.getEvent(), context.getSubscriber(), context.getSubscriberMethod(), this.name, exceptionMessage});
        }
    }

    public static enum Priority {
        NORMAL,
        HIGH;

    }
}

