/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.automation.itf.core.hibernate.spring.managers.custom.SearchManager;
import org.qubership.automation.itf.core.model.jpa.project.StubProject;
import org.qubership.automation.itf.core.util.converter.IdConverter;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.services.projectsettings.AbstractProjectSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ProjectSettingsService
extends AbstractProjectSettingsService {
    private static final Logger log = LoggerFactory.getLogger(ProjectSettingsService.class);
    private final HazelcastInstance hazelcastClient;
    private final CoreObjectManager coreObjectManager;
    @Value(value="${hazelcast.project-settings.cache.refill.time.seconds}")
    private long projectSettingsCacheRefillTime;

    public String get(Object projectId, String shortName) {
        String value = this.get(IdConverter.toBigInt((Object)projectId), shortName, this.getProjectSettingsCache());
        return StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : null;
    }

    protected String get(BigInteger projectId, String shortName, IMap<String, Map<String, String>> projectSettingsCache) {
        try {
            Map projectSettings = this.getProjectSettings(projectSettingsCache, projectId.toString());
            if (Objects.nonNull(projectSettings)) {
                return (String)projectSettings.get(shortName);
            }
            log.warn("Something went wrong with Hazelcast project settings cache - there is no project settings for projectId {}. Trying to get them from database...", (Object)projectId);
            return this.getFromDataBaseAndTryToFillCache(projectId, shortName, projectSettingsCache);
        }
        catch (Exception e) {
            log.error("Error while getting project setting '{}' or filling it to cache for project: {}", new Object[]{shortName, projectId, e});
            return null;
        }
    }

    public boolean getBoolean(Object projectId, String shortName) {
        String value = this.get(IdConverter.toBigInt((Object)projectId), shortName, this.getProjectSettingsCache());
        return StringUtils.isNotEmpty((CharSequence)value) && Boolean.parseBoolean(value.trim());
    }

    public Integer getInt(Object projectId, String shortName) {
        IMap<String, Map<String, String>> projectSettingsCache = this.getProjectSettingsCache();
        String value = this.get(IdConverter.toBigInt((Object)projectId), shortName, projectSettingsCache);
        return StringUtils.isNotEmpty((CharSequence)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public Map<String, String> getAll(Object projectId) {
        IMap<String, Map<String, String>> projectsSettingsCache = this.getProjectSettingsCache();
        Map projectSettings = this.getProjectSettings(projectsSettingsCache, projectId.toString());
        if (Objects.nonNull(projectSettings)) {
            return projectSettings;
        }
        log.warn("Can't get all project settings from cache for project '{}'; getting from db...", projectId);
        return this.getFromDataBaseAndTryToFillCache(IdConverter.toBigInt((Object)projectId), projectsSettingsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCache(StubProject itfProject) {
        BigInteger projectId = (BigInteger)itfProject.getID();
        String pid = projectId.toString();
        IMap<String, Map<String, String>> projectSettingsCache = this.getProjectSettingsCache();
        if (projectSettingsCache.isLocked((Object)pid)) {
            log.info("Project settings for pid {} are locked by another thread/pod of service, waiting for unlock...", (Object)pid);
        }
        projectSettingsCache.lock((Object)pid);
        log.debug("Project settings for projectId {} are locked by current thread/pod", (Object)pid);
        try {
            boolean notEmptyAndUpdatedRecently = this.isNotEmptyAndUpdatedRecently(projectId, projectSettingsCache);
            if (notEmptyAndUpdatedRecently) {
                return;
            }
            Map<String, String> projectSettingsFromDb = this.getAllFromDataBase(projectId);
            this.setAll(projectSettingsFromDb, projectSettingsCache, projectId);
        }
        catch (Exception e) {
            log.error("Error while filling project settings in cache for project: {}", (Object)pid, (Object)e);
        }
        finally {
            projectSettingsCache.unlock((Object)pid);
            log.debug("Project settings for projectId {} are unlocked by current thread/pod", (Object)pid);
        }
    }

    public void fillCache(StubProject project, Map<String, String> projectSettings) {
        IMap<String, Map<String, String>> projectSettingsCache = this.getProjectSettingsCache();
        this.setAll(projectSettings, projectSettingsCache, IdConverter.toBigInt((Object)project.getID()));
    }

    public void update(Object projectId, String shortName, String value, boolean saveToDatabase) {
        if (saveToDatabase) {
            this.setWithSave(projectId, shortName, value);
            return;
        }
        this.setWithoutSave(projectId, shortName, value);
    }

    @Deprecated
    public void add(Object projectId, String shortName, String value) {
        this.setWithSave(projectId, shortName, value);
    }

    protected IMap<String, Map<String, String>> getProjectSettingsCache() {
        return this.hazelcastClient.getMap("ATP_ITF_PROJECT_SETTINGS");
    }

    private void setWithSave(Object projectId, String shortName, String value) {
        try {
            this.updateDataBase(IdConverter.toBigInt((Object)projectId), shortName, value);
            this.set(projectId.toString(), shortName, value);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error while upsert project setting property to cache or database: '%s' for project %s", shortName, projectId), e);
        }
    }

    private void setWithoutSave(Object projectId, String shortName, String value) {
        try {
            this.set(projectId.toString(), shortName, value);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error while upsert project setting property to cache: '%s' for project %s", shortName, projectId), e);
        }
    }

    private String getFromDataBaseAndTryToFillCache(BigInteger projectId, String shortName, IMap<String, Map<String, String>> projectSettingsCacheMap) {
        Map<String, String> projectSettingsFromDb = this.getAllFromDataBase(projectId);
        this.setAll(projectSettingsFromDb, projectSettingsCacheMap, projectId);
        return projectSettingsFromDb.get(shortName);
    }

    private Map<String, String> getFromDataBaseAndTryToFillCache(BigInteger projectId, IMap<String, Map<String, String>> projectSettingsCacheMap) {
        Map<String, String> projectSettingsFromDb = this.getAllFromDataBase(projectId);
        this.setAll(projectSettingsFromDb, projectSettingsCacheMap, projectId);
        return projectSettingsFromDb;
    }

    private void updateDataBase(BigInteger projectId, String shortName, String value) {
        ((SearchManager)this.coreObjectManager.getSpecialManager(StubProject.class, SearchManager.class)).updateProjectSetting(projectId, shortName, value);
    }

    private boolean isNotEmptyAndUpdatedRecently(BigInteger projectId, IMap<String, Map<String, String>> projectSettingsCache) {
        EntryView entryView = projectSettingsCache.getEntryView((Object)projectId.toString());
        return entryView != null && entryView.getLastUpdateTime() > System.currentTimeMillis() - this.projectSettingsCacheRefillTime * 1000L;
    }

    private Map<String, String> getAllFromDataBase(BigInteger projectId) {
        try {
            return ((SearchManager)this.coreObjectManager.getSpecialManager(StubProject.class, SearchManager.class)).getAllProjectSettingsByProjectId(projectId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting project settings from db for projectId " + projectId, e);
        }
    }

    private void set(String projectId, String shortName, String value) {
        try {
            IMap<String, Map<String, String>> projectSettingsCache = this.getProjectSettingsCache();
            Map projectSettings = this.getProjectSettings(projectSettingsCache, projectId);
            projectSettings.put(shortName, value);
            projectSettingsCache.set((Object)projectId, (Object)projectSettings);
        }
        catch (Exception e) {
            log.error("Error while set project settings to cache for projectId {}", (Object)projectId, (Object)e);
        }
    }

    private void setAll(Map<String, String> projectSettings, IMap<String, Map<String, String>> to, BigInteger projectId) {
        try {
            to.set((Object)projectId.toString(), projectSettings);
        }
        catch (Exception e) {
            log.error("Can't set project settings to Hazelcast cache...", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"hazelcastClient", "coreObjectManager"})
    public ProjectSettingsService(HazelcastInstance hazelcastClient, CoreObjectManager coreObjectManager) {
        this.hazelcastClient = hazelcastClient;
        this.coreObjectManager = coreObjectManager;
    }
}

