/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import com.fasterxml.jackson.databind.JsonNode;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.SerializationUtils;

public class SecurityHelper {
    private static final Logger log = LoggerFactory.getLogger(SecurityHelper.class);
    private static final String AUTH_CONTEXT = "authContext";

    private static String serialize(Authentication authentication) {
        byte[] bytes = SerializationUtils.serialize((Object)authentication);
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    private static Authentication deserialize(String authentication) {
        byte[] decoded = DatatypeConverter.parseBase64Binary((String)authentication);
        Authentication auth = (Authentication)SerializationUtils.deserialize((byte[])decoded);
        return auth;
    }

    public static void addAuthContextToMessage(JSONObject message) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String authContext = SecurityHelper.serialize(auth);
            if (StringUtils.isNotEmpty((CharSequence)authContext)) {
                message.put((Object)AUTH_CONTEXT, (Object)authContext);
            }
        }
        catch (Exception e) {
            log.error("An error occurred at processing Security Context.", (Throwable)e);
        }
    }

    public static void propagateSecurityContext(JsonNode message) {
        try {
            String authContext;
            if (message.has(AUTH_CONTEXT) && StringUtils.isNotEmpty((CharSequence)(authContext = message.get(AUTH_CONTEXT).asText()))) {
                Authentication auth = SecurityHelper.deserialize(authContext);
                SecurityContextHolder.getContext().setAuthentication(auth);
            }
        }
        catch (Exception e) {
            log.error("An error occurred at processing Security Context.", (Throwable)e);
        }
    }
}

