/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.environments.openapi.controllers;

import org.qubership.atp.environments.openapi.dto.ConnectionFullVer2ViewDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentDtoDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentNameViewDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentResDto;
import java.util.List;
import org.qubership.atp.environments.openapi.dto.ProjectDto;
import org.qubership.atp.environments.openapi.dto.ProjectDtoDto;
import org.qubership.atp.environments.openapi.dto.ProjectFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.ProjectFullVer2ViewDto;
import org.qubership.atp.environments.openapi.dto.ProjectImplDto;
import org.qubership.atp.environments.openapi.dto.ProjectNameViewDto;
import org.qubership.atp.environments.openapi.dto.StatusDtoDto;
import org.qubership.atp.environments.openapi.dto.SystemEnvironmentsViewDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer2ViewDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-18T15:09:59.429Z[Etc/UTC]")
@Validated
@Tag(name = "ProjectController", description = "Project Controller")
public interface ProjectControllerApi {

    /**
     * POST /api/projects/{projectId}/copy : copy
     *
     * @param projectId projectId (required)
     * @param projectDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copy",
        summary = "copy",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDto> copy(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "ProjectDtoDto", description = "") @Valid @RequestBody(required = false) ProjectDtoDto projectDtoDto
    );


    /**
     * POST /api/projects/{projectId}/environments : createEnvironment
     *
     * @param projectId projectId (required)
     * @param environmentDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createEnvironment",
        summary = "createEnvironment",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/environments",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentResDto> createEnvironment(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "EnvironmentDtoDto", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDto environmentDtoDto
    );


    /**
     * POST /api/projects : create
     *
     * @param projectImplDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createProject",
        summary = "create",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<ProjectDto> createProject(
        @Parameter(name = "ProjectImplDto", description = "") @Valid @RequestBody(required = false) ProjectImplDto projectImplDto
    );


    /**
     * POST /api/projects/{projectId}/tools : createTool
     *
     * @param projectId projectId (required)
     * @param environmentDtoDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "createTool",
        summary = "createTool",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/api/projects/{projectId}/tools",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<EnvironmentResDto> createTool(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "EnvironmentDtoDto", description = "") @Valid @RequestBody(required = false) EnvironmentDtoDto environmentDtoDto
    );


    /**
     * DELETE /api/projects/{projectId} : delete
     *
     * @param projectId projectId (required)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteProject",
        summary = "delete",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/api/projects/{projectId}"
    )
    ResponseEntity<Void> deleteProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/environments/all : getAllEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllEnvironments",
        summary = "getAllEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/all",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDto>> getAllEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects : getAll
     *
     * @param host host (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllProjects",
        summary = "getAll",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectFullVer2ViewDto>> getAllProjects(
        @Parameter(name = "host", description = "host") @Valid @RequestParam(value = "host", required = false) String host,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/short : getAllShort
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShort",
        summary = "getAllShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectNameViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectNameViewDto>> getAllShort(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems/short : Endpoint for getting list of systems on project by projectId
     *
     * @param projectId Project id for getting system (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShortSystemsOnProject",
        summary = "Endpoint for getting list of systems on project by projectId",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemEnvironmentsViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemEnvironmentsViewDto>> getAllShortSystemsOnProject(
        @Parameter(name = "projectId", description = "Project id for getting system", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/shortWithAccess : getAllShortWithAccess
     *
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllShortWithUserAccess",
        summary = "getAllShortWithAccess",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectNameViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/shortWithAccess",
        produces = { "application/json" }
    )
    ResponseEntity<List<ProjectNameViewDto>> getAllShortWithUserAccess(
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/connections : getConnections
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnections",
        summary = "getConnections",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ConnectionFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/connections",
        produces = { "application/json" }
    )
    ResponseEntity<List<ConnectionFullVer2ViewDto>> getConnections(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/connections/name : getConnectionsName
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getConnectionsName",
        summary = "getConnectionsName",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/connections/name",
        produces = { "application/json" }
    )
    ResponseEntity<List<String>> getConnectionsName(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/environments : getEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironments",
        summary = "getEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDto>> getEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/short : getEnvironmentsShort
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnvironmentsShort",
        summary = "getEnvironmentsShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentNameViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentNameViewDto>> getEnvironmentsShort(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId} : getProject
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProject",
        summary = "getProject",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDto> getProject(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems : getSystems
     *
     * @param projectId projectId (required)
     * @param category category (optional)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectSystems",
        summary = "getSystems",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SystemFullVer2ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems",
        produces = { "application/json" }
    )
    ResponseEntity<List<SystemFullVer2ViewDto>> getProjectSystems(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "category", description = "category") @Valid @RequestParam(value = "category", required = false) String category,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/{environmentIds} : getProjectWithSpecifiedEnvironments
     *
     * @param projectId projectId (required)
     * @param environmentIds environmentIds (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getProjectWithSpecifiedEnvironments",
        summary = "getProjectWithSpecifiedEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = ProjectFullVer1ViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/{environmentIds}",
        produces = { "application/json" }
    )
    ResponseEntity<ProjectFullVer1ViewDto> getProjectWithSpecifiedEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "environmentIds", description = "environmentIds", required = true) @PathVariable("environmentIds") List<UUID> environmentIds,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/environments/systems/name : getSystemsName
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getSystemsName",
        summary = "getSystemsName",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = String.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/environments/systems/name",
        produces = { "application/json" }
    )
    ResponseEntity<List<String>> getSystemsName(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * GET /api/projects/{projectId}/temporary/environments : getTemporaryEnvironments
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTemporaryEnvironments",
        summary = "getTemporaryEnvironments",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/temporary/environments",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDto>> getTemporaryEnvironments(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/tools : getTools
     *
     * @param projectId projectId (required)
     * @param full full (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTools",
        summary = "getTools",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentResDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/tools",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentResDto>> getTools(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "full", description = "full") @Valid @RequestParam(value = "full", required = false) Boolean full
    );


    /**
     * GET /api/projects/{projectId}/tools/short : getToolsShort
     *
     * @param projectId projectId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getToolsShort",
        summary = "getToolsShort",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnvironmentNameViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/api/projects/{projectId}/tools/short",
        produces = { "application/json" }
    )
    ResponseEntity<List<EnvironmentNameViewDto>> getToolsShort(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId
    );


    /**
     * PUT /api/projects : update
     *
     * @param projectDtoDto  (optional)
     * @return Created (status code 201)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateProject",
        summary = "update",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/projects",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateProject(
        @Parameter(name = "ProjectDtoDto", description = "") @Valid @RequestBody(required = false) ProjectDtoDto projectDtoDto
    );


    /**
     * PUT /api/projects/{projectId}/systems/status : updateSystemStatuses
     *
     * @param projectId projectId (required)
     * @param statusDtoDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateSystemStatuses",
        summary = "updateSystemStatuses",
        tags = { "project-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Object.class))
            }),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/api/projects/{projectId}/systems/status",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<Object>> updateSystemStatuses(
        @Parameter(name = "projectId", description = "projectId", required = true) @PathVariable("projectId") UUID projectId,
        @Parameter(name = "StatusDtoDto", description = "") @Valid @RequestBody(required = false) List<StatusDtoDto> statusDtoDto
    );

}
