/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.environments.openapi.controllers;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.environments.openapi.dto.BaseSearchRequestDto;
import org.qubership.atp.environments.openapi.dto.CreateSystemDtoDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentDtoDto;
import org.qubership.atp.environments.openapi.dto.EnvironmentFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.SystemDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer1ViewDto;
import org.qubership.atp.environments.openapi.dto.SystemFullVer2ViewDto;
import org.qubership.atp.environments.openapi.dto.SystemNameViewDto;
import org.qubership.atp.environments.openapi.dto.SystemTemporaryDtoDto;
import org.qubership.atp.environments.openapi.dto.SystemVersionResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="EnvironmentController", description="Environment Controller")
public interface EnvironmentControllerApi {
    @Operation(operationId="copy", summary="copy", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDto> copy(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="EnvironmentDtoDto", description="") @Valid @RequestBody(required=false) EnvironmentDtoDto var2);

    @Operation(operationId="createEnvironment", summary="createEnvironment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentDto> createEnvironment(@Parameter(name="EnvironmentDtoDto", description="") @Valid @RequestBody(required=false) EnvironmentDtoDto var1);

    @Operation(operationId="createSystem", summary="createSystem", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<SystemDto> createSystem(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="CreateSystemDtoDto", description="") @Valid @RequestBody(required=false) CreateSystemDtoDto var2);

    @Operation(operationId="deleteEnvironment", summary="delete", tags={"environment-controller"}, responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/environments/{environmentId}"})
    public ResponseEntity<Void> deleteEnvironment(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="detailedUpdateVersion", summary="detailedUpdateVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemVersionResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/environments/{environmentId}/version"}, produces={"application/json"})
    public ResponseEntity<List<SystemVersionResponseDto>> detailedUpdateVersion(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="findBySearchRequest", summary="findBySearchRequest", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/search"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<EnvironmentDto>> findBySearchRequest(@Parameter(name="BaseSearchRequestDto", description="searchRequest", required=true) @Valid @RequestBody BaseSearchRequestDto var1);

    @Operation(operationId="getAll", summary="getAll", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments"}, produces={"application/json"})
    public ResponseEntity<List<EnvironmentFullVer1ViewDto>> getAll(@Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var1);

    @Operation(operationId="getEnvironment", summary="getEnvironment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}"}, produces={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDto> getEnvironment(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getEnvironmentNameById", summary="getName", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/name"}, produces={"text/plain"})
    public ResponseEntity<String> getEnvironmentNameById(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="getEnvironmentSystems", summary="getSystems", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer1ViewDto>> getEnvironmentSystems(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getEnvironmentTsg3", summary="Returns all systems with updated versions under environment", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems/update-versions"}, produces={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDto> getEnvironmentTsg3(@Parameter(name="environmentId", description="Id of the environment. Cannot be empty.", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2);

    @Operation(operationId="getPublicHtmlVersion", summary="getPublicHtmlVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/public/v1/environments/{environmentIds}/systems/htmlVersions"}, produces={"text/plain"})
    public ResponseEntity<String> getPublicHtmlVersion(@Parameter(name="environmentIds", description="environmentIds", required=true) @PathVariable(value="environmentIds") List<UUID> var1);

    @Operation(operationId="getSystemV2", summary="getSystemV2", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemFullVer2ViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v2/environments/{environmentId}/systems"}, produces={"application/json"})
    public ResponseEntity<List<SystemFullVer2ViewDto>> getSystemV2(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="system_type", description="system_type") @Valid @RequestParam(value="system_type", required=false) String var2, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var3);

    @Operation(operationId="getSystemsShort", summary="getSystemsShort", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemNameViewDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/systems/short"}, produces={"application/json"})
    public ResponseEntity<List<SystemNameViewDto>> getSystemsShort(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);

    @Operation(operationId="temporary", summary="temporary", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnvironmentFullVer1ViewDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/environments/{environmentId}/temporary"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<EnvironmentFullVer1ViewDto> temporary(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1, @Parameter(name="full", description="full") @Valid @RequestParam(value="full", required=false) Boolean var2, @Parameter(name="SystemTemporaryDtoDto", description="") @Valid @RequestBody(required=false) List<SystemTemporaryDtoDto> var3);

    @Operation(operationId="updateEnvironment", summary="update", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/environments"}, consumes={"application/json"})
    public ResponseEntity<Void> updateEnvironment(@Parameter(name="EnvironmentDtoDto", description="") @Valid @RequestBody(required=false) EnvironmentDtoDto var1);

    @Operation(operationId="updateVersion", summary="updateVersion", tags={"environment-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=SystemDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/environments/{environmentId}/version"}, produces={"application/json"})
    public ResponseEntity<List<SystemDto>> updateVersion(@Parameter(name="environmentId", description="environmentId", required=true) @PathVariable(value="environmentId") UUID var1);
}

