/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.execution;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.qubership.automation.itf.core.execution.ExecutorServiceProviderFactory;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextCallChainSubscriber;
import org.qubership.automation.itf.core.model.event.CallChainEvent;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.iterator.CallChainStepIterator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DebugExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugExecutor.class);
    private EventBusProvider eventBusProvider;

    @Autowired
    public DebugExecutor(EventBusProvider eventBusProvider) {
        this.eventBusProvider = eventBusProvider;
    }

    public TcContext executeCallChainBeginStep(TcContext tcContext, Step step) {
        return this.executeCallChainBeginStep(tcContext, (CallChainInstance)CallChainInstance.class.cast(tcContext.getInitiator()), (SituationStep)SituationStep.class.cast(step));
    }

    private TcContext executeCallChainBeginStep(TcContext tcContext, CallChainInstance instance, SituationStep beginnerSituationStep) {
        ExecutorServiceProviderFactory.get().requestForRegular().submit(() -> this.execute(tcContext, instance, beginnerSituationStep));
        return instance.getContext().tc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TcContext tcContext, CallChainInstance instance, SituationStep beginnerSituationStep) {
        String threadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("[" + instance.getContext().tc().getID() + "] " + instance.getName());
            TxExecutor.execute(() -> {
                this._execute(tcContext, beginnerSituationStep);
                return null;
            });
        }
        catch (Exception t) {
            LOGGER.error("Error executing in separate thread {}", (Object)instance, (Object)t);
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
    }

    private void _execute(TcContext tcContext, SituationStep beginnerSituationStep) {
        CallChainInstance instance = this.reviveContextAndGetInstance(tcContext);
        LOGGER.info("Executing Call Chain {}...", (Object)instance);
        this.reviveAndPostInstance(instance, beginnerSituationStep);
    }

    private CallChainInstance reviveContextAndGetInstance(TcContext tcContext) {
        CacheServices.getTcBindingCacheService().bind(tcContext);
        CallChainInstance instance = (CallChainInstance)tcContext.getInitiator();
        if (tcContext.getInitiator().getContext() == null) {
            tcContext.getInitiator().setContext(new InstanceContext());
        }
        tcContext.getInitiator().getContext().setTC(tcContext);
        tcContext.setStartedFrom(StartedFrom.ITF_UI);
        instance.setStatus(Status.IN_PROGRESS);
        instance.setStartTime(new Date());
        ExecutionServices.getTCContextService().prolong(instance.getContext().tc());
        return instance;
    }

    private void reviveAndPostInstance(CallChainInstance instance, SituationStep beginnerSituationStep) {
        ExecutionServices.getCallChainExecutorService().runBeforeIntegrations(instance);
        this.eventBusProvider.post((Event)new CallChainEvent.Start(instance));
        ArrayList steps = Lists.newArrayList();
        NextCallChainEvent nextCallChainEvent = new NextCallChainEvent(null, instance);
        CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById((Object)instance.getTestCaseId());
        this.searchingPointOfEntrySteps(callChain, beginnerSituationStep, steps);
        CallChainStepIterator stepIterator = new CallChainStepIterator(callChain, (AbstractContainerInstance)instance, (List)steps);
        NextCallChainSubscriber subscriber = new NextCallChainSubscriber(nextCallChainEvent, stepIterator);
        this.eventBusProvider.register(subscriber, EventBusProvider.Priority.HIGH);
        this.eventBusProvider.post((Event)nextCallChainEvent);
    }

    private List<Step> searchingPointOfEntrySteps(CallChain parent, SituationStep situationStep, List<Step> steps) {
        boolean currentStepFound = false;
        for (Step step : parent.getSteps()) {
            if (step instanceof SituationStep) {
                if (situationStep.equals((Object)step)) {
                    currentStepFound = true;
                }
                if (!currentStepFound) continue;
                steps.add(step);
                continue;
            }
            if (!(step instanceof EmbeddedStep) || ((EmbeddedStep)step).getChain() == null) continue;
            this.searchingPointOfEntrySteps(((EmbeddedStep)step).getChain(), situationStep, steps);
        }
        return steps;
    }
}

