/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.execution;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitTimeMonitoringThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitTimeMonitoringThreadPoolExecutor.class);

    public WaitTimeMonitoringThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public WaitTimeMonitoringThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public WaitTimeMonitoringThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public WaitTimeMonitoringThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        long startTime = System.currentTimeMillis();
        return super.submit(() -> {
            this.warnLongDuration(startTime);
            return task.call();
        });
    }

    @Override
    public Future<?> submit(Runnable task) {
        long startTime = System.currentTimeMillis();
        return super.submit(() -> {
            this.warnLongDuration(startTime);
            task.run();
        });
    }

    private void warnLongDuration(long startTime) {
        long queueDuration = System.currentTimeMillis() - startTime;
        if (queueDuration >= 1000L) {
            LOGGER.warn("Task awaited in the queue: {} (msecs)", (Object)queueDuration);
        }
    }
}

