/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.step.impl;

import com.google.common.base.Strings;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.instance.chain.IncomingHelper;
import org.qubership.automation.itf.core.instance.step.impl.FiledProcessorChain;
import org.qubership.automation.itf.core.instance.step.impl.chain.TemplateProcessor;
import org.qubership.automation.itf.core.message.parser.ProducerMessageHelper;
import org.qubership.automation.itf.core.metric.MetricsAggregateService;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.model.interceptor.Interceptor;
import org.qubership.automation.itf.core.model.interceptor.TransportInterceptor;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.environment.Environment;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.qubership.automation.itf.core.model.jpa.message.parser.MessageParameter;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.system.System;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.transport.TransportConfiguration;
import org.qubership.automation.itf.core.model.transport.ConnectionProperties;
import org.qubership.automation.itf.core.util.TemplateHelper;
import org.qubership.automation.itf.core.util.descriptor.PropertyDescriptor;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.exception.NoDeployedTransportException;
import org.qubership.automation.itf.core.util.format.Formatter;
import org.qubership.automation.itf.core.util.format.Formatters;
import org.qubership.automation.itf.core.util.helper.Comparators;
import org.qubership.automation.itf.core.util.helper.KeyHelper;
import org.qubership.automation.itf.core.util.holder.ActiveInterceptorHolder;
import org.qubership.automation.itf.core.util.loader.InterceptorClassLoader;
import org.qubership.automation.itf.core.util.logger.TimeLogger;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.manager.TransportRegistryManager;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class IntegrationStepHelper {
    private static final Logger log = LoggerFactory.getLogger(IntegrationStepHelper.class);
    private static final String CONTEXT_ID = "ContextId";
    private static final String TRANSPORT_ID = "transportId";
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final IncomingHelper incomingHelper;
    private final MetricsAggregateService metricsAggregateService;
    private final ProjectSettingsService projectSettingsService;

    public static boolean notLastValidationAttempt(StepInstance currentStepInstance, StepInstance nextStepInstance) {
        if (!currentStepInstance.isRetryStep()) {
            return false;
        }
        return currentStepInstance.getStep().equals(nextStepInstance.getStep());
    }

    void sendRequest(StepInstance stepInstance) throws Exception {
        TimeLogger.LOGGER.debug("Start for method: IntegrationStepHelper.sendRequest");
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        Operation integrationStepOperation = this.getAndCheckOperation(stepInstance, integrationStep);
        TransportConfiguration transportConfiguration = this.getAndCheckConfigurationFromDB(stepInstance, integrationStepOperation.getTransport());
        AccessTransport transport = this.getAndCheckRemoteTransport(stepInstance, transportConfiguration.getTypeName());
        Environment environment = this.getAndCheckEnvironment(stepInstance.getContext().tc());
        Message message = ProducerMessageHelper.getInstance().produceMessage(TemplateHelper.getById((Object)integrationStep.returnStepTemplate().getID()), stepInstance.getContext(), integrationStepOperation, environment);
        this.computeConnectionProperties(message, environment, integrationStep, transportConfiguration, transport, stepInstance.getContext());
        this.processInterceptors(integrationStep, transportConfiguration, environment, message);
        stepInstance.setOutgoingMessage(message);
        String sessionId = transport.send(stepInstance.getOutgoingMessage(), null, stepInstance.getParent().getContext().getProjectUuid());
        stepInstance.getContext().setSessionId((Object)sessionId);
        stepInstance.getParent().getContext().setSessionId((Object)sessionId);
        TimeLogger.LOGGER.debug("End for method: IntegrationStepHelper.sendRequest");
    }

    void sendReceiveSync(StepInstance stepInstance) throws Exception {
        Message response;
        TimeLogger.LOGGER.debug("Start for method: IntegrationStepHelper.sendReceiveSync");
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        Operation integrationStepOperation = this.getAndCheckOperation(stepInstance, integrationStep);
        Situation situation = integrationStep.getParent();
        TransportConfiguration transportConfiguration = this.getAndCheckConfiguration(stepInstance, integrationStepOperation.getTransport());
        AccessTransport transport = this.getAndCheckRemoteTransport(stepInstance, transportConfiguration.getTypeName());
        Environment environment = this.getAndCheckEnvironment(stepInstance.getContext().tc());
        Message message = ProducerMessageHelper.getInstance().produceMessage(integrationStep.returnStepTemplate(), stepInstance.getContext(), integrationStepOperation, environment);
        this.computeConnectionProperties(message, environment, integrationStep, transportConfiguration, transport, stepInstance.getContext());
        stepInstance.setOutgoingMessage(message);
        BigInteger projectId = stepInstance.getContext().tc().getProjectId();
        boolean responseFromCache = false;
        String stringTtl = message.getConnectionProperties().getOrDefault("cacheResponseForSeconds", "").toString();
        if (StringUtils.isNumeric((CharSequence)stringTtl)) {
            String key = String.format("%s_%s%s", projectId, message.getConnectionPropertiesParameter("baseUrl"), message.getConnectionPropertiesParameter("endpoint"));
            response = CacheServices.getResponseCacheService().getByKey(key);
            if (Objects.isNull(response)) {
                response = transport.sendReceiveSync(message, projectId);
                CacheServices.getResponseCacheService().set(key, stringTtl, response);
            } else {
                responseFromCache = true;
            }
        } else {
            response = transport.sendReceiveSync(message, projectId);
        }
        if (!responseFromCache && Boolean.parseBoolean(this.projectSettingsService.get(projectId, "message.pretty.format", "false"))) {
            this.formatBody(response, transportConfiguration.getTypeName());
        }
        stepInstance.setIncomingMessage(response);
        stepInstance.getContext().sp().put((Object)"endpointForRam", message.getConnectionProperties() != null && message.getConnectionProperties().containsKey("Resolved_Endpoint_URL") ? message.getConnectionProperties().get("Resolved_Endpoint_URL") : transportConfiguration.get((Object)"endpoint"));
        stepInstance.getContext().sp().put((Object)"incomingHeaders", (Object)response.getHeaders());
        stepInstance.getContext().sp().put((Object)"incomingConnectionProperties", (Object)response.getConnectionProperties());
        Map<String, MessageParameter> map = this.incomingHelper.processOutboundResponseMessage(transportConfiguration.getParent(), integrationStepOperation, situation, response, stepInstance.getContext(), stepInstance.getContext().tc().getProjectId());
        stepInstance.getContext().sp().putMessageParameters(map.values());
        ExecutionServices.getTCContextService().setMessageParameters(stepInstance.getContext().tc(), map);
        if (response.getFailedMessage() != null) {
            throw new RuntimeException(response.getFailedMessage());
        }
        TimeLogger.LOGGER.debug("End for method: IntegrationStepHelper.sendReceiveSync");
    }

    @AtpJaegerLog(spanTags={@AtpSpanTag(key="send.response.step.instance.id", value="#stepInstance.stepId.toString()")})
    void sendSyncResponse(StepInstance stepInstance) {
        MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)MDC.get((String)MdcField.STUB_TRACE_ID.toString()));
        TimeLogger.LOGGER.debug("Start for method: IntegrationStepHelper.sendSyncResponse");
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        Operation operation = this.getAndCheckOperation(stepInstance, integrationStep);
        Message message = ProducerMessageHelper.getInstance().produceMessage(integrationStep.returnStepTemplate(), stepInstance.getContext(), operation);
        message.setFailedMessage(stepInstance.getErrorMessage());
        if (stepInstance.getContext().getConnectionProperties() != null) {
            message.fillConnectionProperties((Map)stepInstance.getContext().getConnectionProperties());
        }
        message.fillHeaders(message.getConnectionProperties(), "headers");
        stepInstance.setOutgoingMessage(message);
        String projectUuid = stepInstance.getContext().getProjectUuid().toString();
        this.executorToMessageBrokerSender.sendMessageToExecutorStubsOutgoingResponseQueue(new TriggerExecutionMessage(message, (String)stepInstance.getParent().getContext().getSessionId(), (String)stepInstance.getParent().getContext().getMessageBrokerSelectorValue()), projectUuid);
        this.collectDurationMetric(stepInstance.getContext().getTC(), stepInstance.getContext().getProjectUuid());
        TimeLogger.LOGGER.debug("End for method: IntegrationStepHelper.sendSyncResponse");
    }

    private void collectDurationMetric(TcContext tcContext, UUID projectUuid) {
        Object startTimeObject = tcContext.get((Object)"executor_start_time");
        if (startTimeObject instanceof String) {
            try {
                OffsetDateTime started = OffsetDateTime.parse((String)startTimeObject);
                OffsetDateTime finished = OffsetDateTime.now();
                tcContext.put((Object)"executor_finish_time", (Object)finished.toString());
                Duration duration = Duration.between(started, finished);
                tcContext.put((Object)"executor_duration", (Object)String.valueOf(duration.toMillis()));
                Object endpointObject = tcContext.get((Object)"executor_endpoint");
                String endpoint = endpointObject == null ? "n/a" : endpointObject.toString();
                this.metricsAggregateService.recordIncomingRequestDuration(projectUuid, endpoint, duration);
            }
            catch (DateTimeParseException dtpe) {
                log.error("Error while collecting duration metrics", (Throwable)dtpe);
            }
        }
    }

    private void computeConnectionProperties(Message message, Environment environment, IntegrationStep integrationStep, TransportConfiguration transportConfiguration, AccessTransport transport, InstanceContext instanceContext) throws Exception {
        Server server = this.getAndCheckServer(environment, integrationStep.getReceiver());
        ConnectionProperties connectionProperties = server.calculate(integrationStep.getReceiver(), transportConfiguration, message, integrationStep.returnStepTemplate(), instanceContext);
        connectionProperties.put((Object)CONTEXT_ID, (Object)instanceContext.getTC().getID().toString());
        connectionProperties.put((Object)TRANSPORT_ID, (Object)transportConfiguration.getID().toString());
        message.fillConnectionProperties((Map)connectionProperties);
        this.prepareLoadTemplateProperties(transport, message, instanceContext);
        this.processDynamicHeaders(transport, instanceContext, message);
        this.processDynamicProperties(transport, instanceContext, message);
        message.fillHeaders(message.getConnectionProperties(), "headers");
    }

    private void processDynamicHeaders(AccessTransport transport, InstanceContext context, Message message) throws RemoteException {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        transport.getProperties().forEach(property -> {
            String shortName = property.getShortName();
            Object obtain = connectionProperties.obtain(shortName);
            if (obtain instanceof String) {
                String propertyValue = (String)obtain;
                propertyValue = TemplateProcessor.getInstance().process(null, propertyValue, context, connectionProperties);
                connectionProperties.put((Object)shortName, (Object)propertyValue);
            }
        });
        message.getConnectionProperties().putAll(connectionProperties);
    }

    private void processDynamicProperties(AccessTransport transport, InstanceContext context, Message message) throws RemoteException {
        ConnectionProperties connectionProperties = (ConnectionProperties)message.getConnectionProperties();
        transport.getProperties().forEach(property -> {
            String shortName = property.getShortName();
            Object obtain = connectionProperties.obtain(shortName);
            if (property.isDynamic()) {
                if (obtain instanceof String) {
                    String propertyValue = (String)obtain;
                    propertyValue = TemplateEngineFactory.get().process((Storable)null, propertyValue, (JsonContext)context, "Connection property '" + shortName + "'");
                    connectionProperties.put((Object)shortName, (Object)propertyValue);
                } else if (obtain instanceof HashMap) {
                    HashMap properties = (HashMap)obtain;
                    HashMap updatedProperties = (HashMap)obtain;
                    for (Map.Entry entry : properties.entrySet()) {
                        if (entry.getValue() instanceof List) {
                            List oldlist = (List)entry.getValue();
                            ArrayList<String> newlist = new ArrayList<String>();
                            for (String elem : oldlist) {
                                newlist.add(TemplateEngineFactory.get().process((Storable)null, elem, (JsonContext)context, "Connection property '" + shortName + "'"));
                            }
                            updatedProperties.put(entry.getKey(), newlist);
                            continue;
                        }
                        String propertyValue = TemplateEngineFactory.get().process((Storable)null, (String)entry.getValue(), (JsonContext)context, "Connection property '" + shortName + "'");
                        updatedProperties.put(entry.getKey(), propertyValue);
                    }
                    connectionProperties.put((Object)shortName, (Object)updatedProperties);
                }
            }
        });
        message.getConnectionProperties().putAll(connectionProperties);
    }

    private void processInterceptors(IntegrationStep integrationStep, TransportConfiguration transportConfiguration, Environment environment, Message message) throws Exception {
        TimeLogger.LOGGER.debug("Start for method: IntegrationStepHelper.processInterceptors");
        Map objectInterceptorMap = (Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(integrationStep.returnStepTemplate().getID().toString());
        if (objectInterceptorMap == null || objectInterceptorMap.isEmpty()) {
            objectInterceptorMap = (Map)ActiveInterceptorHolder.getInstance().getActiveInterceptors().get(transportConfiguration.getID().toString());
        }
        if (objectInterceptorMap != null) {
            ArrayList interceptors = new ArrayList(objectInterceptorMap.values());
            interceptors.sort(Comparators.INTERCEPTOR_COMPARATOR);
            for (Interceptor interceptor : interceptors) {
                if (interceptor.isActive() && interceptor.isApplicable(environment.getID().toString(), integrationStep.getReceiver().getID().toString())) {
                    TransportInterceptor transportInterceptor = InterceptorClassLoader.getInstance().getInstanceClass(interceptor.getTypeName(), new Object[]{interceptor});
                    transportInterceptor.apply(message);
                    log.info("{} interceptor is applied", (Object)interceptor.getName());
                    continue;
                }
                log.info("{} interceptor isn't applied, due to isn't applicable for current environment/receiver", (Object)interceptor.getName());
            }
        }
        TimeLogger.LOGGER.debug("End for method: IntegrationStepHelper.processInterceptors");
    }

    void processOutgoingContextKeys(StepInstance stepInstance) {
        TimeLogger.LOGGER.debug("Start for method: IntegrationStepHelper.processOutgoingContextKeys");
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        String outgoingContextKeyDefinition = integrationStep.getOperation().getOutgoingContextKeyDefinition();
        Operation parent = integrationStep.getOperation();
        if (outgoingContextKeyDefinition == null) {
            outgoingContextKeyDefinition = integrationStep.getOperation().getParent().getOutgoingContextKeyDefinition();
            parent = integrationStep.getOperation().getParent();
        }
        if (outgoingContextKeyDefinition != null) {
            try {
                String contextKey = KeyHelper.defineKey((String)outgoingContextKeyDefinition, (InstanceContext)stepInstance.getContext(), (Storable)parent);
                if (!Strings.isNullOrEmpty((String)contextKey) && CacheServices.getTcBindingCacheService().bind(contextKey, stepInstance.getContext().tc())) {
                    log.debug("Context key for step instance {} is {}", (Object)stepInstance, (Object)contextKey);
                }
            }
            catch (Exception e) {
                log.error("Error processing outgoing context definition", (Throwable)e);
            }
        }
        TimeLogger.LOGGER.debug("End  for method: IntegrationStepHelper.processOutgoingContextKeys");
    }

    private Operation getAndCheckOperation(StepInstance stepInstance, IntegrationStep integrationStep) {
        Operation integrationStepOperation = integrationStep.getOperation();
        if (integrationStepOperation == null) {
            throw new IllegalStateException(String.format("Operation is not set! Step: '%s', parent: '%s'", stepInstance.getStep().getName(), stepInstance.getParent().getStepContainer().getName()));
        }
        return integrationStepOperation;
    }

    private TransportConfiguration getAndCheckConfigurationFromDB(StepInstance stepInstance, TransportConfiguration transportConfigurationLink) {
        if (transportConfigurationLink == null) {
            throw new IllegalStateException(String.format("Transport isn't set for operation! Step: '%s', parent: '%s'", stepInstance.getStep().getName(), stepInstance.getParent().getStepContainer().getName()));
        }
        TransportConfiguration transportConfiguration = (TransportConfiguration)CoreObjectManager.managerFor(TransportConfiguration.class).getById(transportConfigurationLink.getID());
        if (transportConfiguration == null) {
            throw new IllegalStateException(String.format("Transport isn't set for operation! Step: '%s', parent: '%s'", stepInstance.getStep().getName(), stepInstance.getParent().getStepContainer().getName()));
        }
        return transportConfiguration;
    }

    private TransportConfiguration getAndCheckConfiguration(StepInstance stepInstance, TransportConfiguration transportConfigurationLink) {
        if (transportConfigurationLink == null) {
            throw new IllegalStateException(String.format("Transport isn't set for operation! Step: '%s', parent: '%s'", stepInstance.getStep().getName(), stepInstance.getParent().getStepContainer().getName()));
        }
        return transportConfigurationLink;
    }

    private AccessTransport getAndCheckRemoteTransport(StepInstance stepInstance, String transportTypeName) throws NoDeployedTransportException {
        AccessTransport transport = TransportRegistryManager.getInstance().find(transportTypeName);
        if (transport == null) {
            throw new IllegalStateException(String.format("Transport is not bound for operation! Step: '%s', parent: '%s', transport type: '%s'", stepInstance.getStep().getName(), stepInstance.getParent().getStepContainer().getName(), transportTypeName));
        }
        return transport;
    }

    private Environment getAndCheckEnvironment(TcContext tcContext) {
        if (tcContext.getEnvironmentId() == null) {
            throw new IllegalStateException(String.format("Environment has not been set up for context '%s'", tcContext.getName()));
        }
        Environment environment = (Environment)CoreObjectManager.managerFor(Environment.class).getById((Object)tcContext.getEnvironmentId());
        if (environment == null) {
            throw new IllegalStateException(String.format("Environment isn't found by id [%s] for context '%s'", tcContext.getEnvironmentId(), tcContext.getName()));
        }
        return environment;
    }

    private Server getAndCheckServer(Environment environment, System receiverSystem) {
        Server server = (Server)environment.getOutbound().get(receiverSystem);
        if (server == null) {
            throw new IllegalStateException(String.format("No associated server found for system '%s' in environment '%s'", receiverSystem, environment));
        }
        return server;
    }

    private void prepareLoadTemplateProperties(AccessTransport transport, Message message, InstanceContext context) {
        try {
            for (PropertyDescriptor propertyDescriptor : transport.getProperties()) {
                FiledProcessorChain.getInstance().process(propertyDescriptor, message, context);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void checkErrors(StepInstance stepInstance) {
        Throwable error;
        if (stepInstance.getParent().getErrorMessage() != null && (error = stepInstance.getParent().getError()) != null) {
            boolean isValidException = error.getClass().isAssignableFrom(EngineIntegrationException.class);
            if (isValidException) {
                if (((IntegrationStep)stepInstance.getStep()).getSender() == null) {
                    stepInstance.setError((Throwable)new EngineIntegrationException(stepInstance.getParent().getError()));
                }
            } else {
                throw new IllegalArgumentException(stepInstance.getParent().getErrorMessage());
            }
        }
    }

    private void formatBody(Message message, String transportType) {
        Formatter formatter = Formatters.getFormatterOrNull(transportType);
        if (formatter != null) {
            message.setText(formatter.format(message.getText()));
        }
    }

    @ConstructorProperties(value={"executorToMessageBrokerSender", "incomingHelper", "metricsAggregateService", "projectSettingsService"})
    public IntegrationStepHelper(ExecutorToMessageBrokerSender executorToMessageBrokerSender, IncomingHelper incomingHelper, MetricsAggregateService metricsAggregateService, ProjectSettingsService projectSettingsService) {
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.incomingHelper = incomingHelper;
        this.metricsAggregateService = metricsAggregateService;
        this.projectSettingsService = projectSettingsService;
    }
}

