/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution;

import java.beans.ConstructorProperties;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.DefferedSituationInstanceHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.NextCallChainEventSubscriberHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.SubscriberData;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExecutionProcessManagerService {
    public static final String PAUSE_EVENT = "pause";
    public static final String RESUME_EVENT = "resume";
    public static final String TERMINATE_EVENT = "terminate";
    private static final String UPDATE_CONTEXT_EVENT = "updateContext";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionProcessManagerService.class);
    private final EventBusProvider eventBusProvider;

    public void pause(TcContext tcContext) {
        ExecutionServices.getTCContextService().pause(tcContext);
    }

    public void updateContext(TcContext tcContext) {
        SubscriberData resumingData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(tcContext.getID());
        if (resumingData != null) {
            ExecutionServices.getTCContextService().updateContext(tcContext);
            this.eventBusProvider.post((Event)this.createEvent(UPDATE_CONTEXT_EVENT, resumingData, (CallChainInstance)tcContext.getInitiator()));
        }
    }

    @Transactional
    public void resume(TcContext tcContext) {
        SituationInstance situationInstance = DefferedSituationInstanceHolder.getInstance().get(tcContext.getID());
        if (situationInstance == null) {
            this.fail(tcContext);
            LOGGER.error("Error occurred while resuming the {} context: there is no situation instance to resume in the context", (Object)tcContext.getName());
        } else {
            this.executeDeferredSituationInstance(situationInstance, tcContext);
        }
    }

    public void finish(TcContext tcContext) {
        DefferedSituationInstanceHolder.getInstance().remove(tcContext.getID());
        ExecutionServices.getTCContextService().finish(tcContext);
        NextCallChainEventSubscriberHolder.getInstance().remove(tcContext.getID());
    }

    public void fail(TcContext tcContext) {
        ExecutionServices.getTCContextService().fail(tcContext);
        NextCallChainEventSubscriberHolder.getInstance().remove(tcContext.getID());
    }

    public void failByTimeout(TcContext tcContext) {
        ExecutionServices.getTCContextService().failByTimeout(tcContext);
        NextCallChainEventSubscriberHolder.getInstance().remove(tcContext.getID());
    }

    private void executeDeferredSituationInstance(SituationInstance situationInstance, TcContext tcContext) {
        SubscriberData resumingData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(tcContext.getID());
        ExecutionServices.getSituationExecutorService().executeInstance(situationInstance, null, null, this.createEvent(RESUME_EVENT, resumingData, (CallChainInstance)tcContext.getInitiator()));
    }

    private NextCallChainEvent createEvent(String eventType, SubscriberData resumingData, CallChainInstance callChainInstance) {
        NextCallChainEvent.Pause event = null;
        switch (eventType) {
            case "pause": {
                event = new NextCallChainEvent.Pause(resumingData.getParentSubscriberId(), callChainInstance);
                break;
            }
            case "resume": {
                event = !resumingData.isNeedToContinue() ? new NextCallChainEvent.ResumeWithoutContinue(resumingData.getParentSubscriberId(), callChainInstance) : new NextCallChainEvent.Resume(resumingData.getParentSubscriberId(), callChainInstance);
                break;
            }
            case "updateContext": {
                event = new NextCallChainEvent.UpdateContext(resumingData.getParentSubscriberId(), callChainInstance);
                this.eventBusProvider.post((Event)event);
            }
        }
        if (event != null) {
            event.setID(resumingData.getSubscriberId());
        }
        return event;
    }

    @ConstructorProperties(value={"eventBusProvider"})
    public ExecutionProcessManagerService(EventBusProvider eventBusProvider) {
        this.eventBusProvider = eventBusProvider;
    }
}

