/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.testcase.execution.subscriber;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.multitenancy.core.context.TenantContext;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.AbstractChainSubscriber;
import org.qubership.automation.itf.core.instance.testcase.execution.subscriber.NextCallChainSubscriber;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.event.CallChainEvent;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.NextEmbeddedStepEvent;
import org.qubership.automation.itf.core.model.jpa.callchain.CallChain;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.EmbeddedStep;
import org.qubership.automation.itf.core.model.testcase.TestCase;
import org.qubership.automation.itf.core.regenerator.KeysRegenerator;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.executor.provider.EventBusServiceProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;

public class NextEmbeddedStepSubscriber
extends AbstractChainSubscriber<NextEmbeddedStepEvent> {
    public NextEmbeddedStepSubscriber(String id, String parentId) {
        super(id, parentId);
    }

    @Override
    protected void unregisterIfExpired() {
    }

    @Subscribe
    @AllowConcurrentEvents
    public void handle(NextEmbeddedStepEvent event) {
        this.handleEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEvent(NextEmbeddedStepEvent event) throws Exception {
        TenantContext.setTenantInfo((String)this.getTenantId(event));
        StepInstance instance = (StepInstance)event.getInstance();
        EmbeddedStep step = (EmbeddedStep)instance.getStep();
        CallChain callChain = (CallChain)CoreObjectManager.getInstance().getManager(CallChain.class).getById(step.getChain().getID());
        TcContext tcContext = instance.getContext().tc();
        try {
            this.modifyContext(instance.getContext(), step);
            CallChainInstance chainInstance = ExecutionServices.getCallChainExecutorService().prepare(tcContext.getProjectId(), tcContext.getProjectUuid(), (TestCase)callChain, tcContext, tcContext.getEnvironmentById(), null, null);
            chainInstance.setDatasetName(event.getDataSetName());
            chainInstance.setStartTime(new Date());
            NextCallChainEvent chainEvent = new NextCallChainEvent(this.getParentId(), chainInstance);
            NextCallChainSubscriber subscriber = new NextCallChainSubscriber(chainEvent);
            subscriber.registerSubscriberInHolder();
            EventBusServiceProvider.getStaticReference().register(subscriber);
            EventBusServiceProvider.getStaticReference().post((Event)new CallChainEvent.Start(chainInstance));
            EventBusServiceProvider.getStaticReference().post((Event)chainEvent);
        }
        catch (Exception exc) {
            EventBusServiceProvider.getStaticReference().post((Event)new NextCallChainEvent.Fail(this.getParentId(), exc));
        }
        finally {
            this.destroy();
        }
    }

    @Override
    @NotNull
    protected String getTenantId(NextEmbeddedStepEvent event) {
        return ((StepInstance)event.getInstance()).getContext().getProjectUuid().toString();
    }

    private void modifyContext(InstanceContext context, EmbeddedStep step) {
        TxExecutor.executeUnchecked(() -> {
            TemplateEngineFactory.get().process((Storable)step, step.getPreScript(), (JsonContext)context, "pre-script of CallChain Step '" + step.getName() + "'");
            KeysRegenerator.getInstance().regenerateKeys(context, ((EmbeddedStep)CoreObjectManager.getInstance().getManager(EmbeddedStep.class).getById(step.getID())).getKeysToRegenerate());
            return null;
        });
    }
}

