/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.startup;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.NotImplementedException;
import org.qubership.automation.itf.core.startup.Error;

public class StartupErrorCollector {
    private static final StartupErrorCollector INSTANCE = new StartupErrorCollector();
    private LinkedList<Error> errors = Lists.newLinkedList();

    public static StartupErrorCollector getInstance() {
        return INSTANCE;
    }

    public void addError(@Nonnull String place, @Nonnull String message, @Nullable Throwable exception) {
        this.addError(new Error(place, message, exception));
    }

    public void addError(@Nonnull Error error) {
        this.errors.add(error);
    }

    public List<Error> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Deprecated
    public void resolve(String id) {
        throw new NotImplementedException("Resolving startup errors is not implemented yet");
    }

    public void cleanUp() {
        this.errors.clear();
    }
}

