/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.hibernate.spring.managers.executor.ServerObjectManager;
import org.qubership.automation.itf.core.model.jpa.server.Server;
import org.qubership.automation.itf.core.util.db.TxExecutor;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;

@Service
public class UnusedConfigurationsCleanerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedConfigurationsCleanerService.class);
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final long initialDelay = 180L;
    private final long delay = 172800L;
    private boolean stopped = false;

    public void startWorker() {
        LOGGER.info("Unused Configuration Removing Service is started.");
        this.service.scheduleWithFixedDelay(this::deleteUnusedOutboundConfigurations, 180L, 172800L, TimeUnit.SECONDS);
    }

    public void stop() {
        LOGGER.info("Worker is stopped.");
        this.service.shutdown();
        this.stopped = true;
    }

    private void deleteUnusedOutboundConfigurations() {
        String activityName = "Removing of Unused Outbound Configurations by schedule";
        TxExecutor.executeUnchecked(() -> {
            try {
                LOGGER.info("{} is started...", (Object)"Removing of Unused Outbound Configurations by schedule");
                int deletedCount = ((ServerObjectManager)CoreObjectManager.getInstance().getSpecialManager(Server.class, ServerObjectManager.class)).deleteUnusedOutboundConfigurations();
                LOGGER.info("{} is completed ({} rows deleted).", (Object)"Removing of Unused Outbound Configurations by schedule", (Object)deletedCount);
            }
            catch (Throwable t) {
                LOGGER.error("Error while {}", (Object)"Removing of Unused Outbound Configurations by schedule", (Object)t);
            }
            return null;
        }, (TransactionDefinition)TxExecutor.defaultWritableTransaction());
    }
}

