/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.MapListener;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.qubership.automation.itf.executor.cache.hazelcast.listener.DiameterConnectionInfoEvictedListener;
import org.qubership.automation.itf.executor.cache.hazelcast.listener.ResponseEntryExpiredListener;
import org.qubership.automation.itf.executor.cache.hazelcast.listener.TCContextEntryExpiredListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableCaching
@Configuration
public class CommonHazelcastConfig {
    private static final Logger log = LoggerFactory.getLogger(CommonHazelcastConfig.class);

    protected static void tryToCreateMapConfigsIfNotExist(HazelcastInstance hazelcastInstance, boolean remoteInstance) {
        Config config = hazelcastInstance.getConfig();
        CommonHazelcastConfig.configCache(config, "ATP_ITF_TC_CONTEXTS", true);
        CommonHazelcastConfig.configCache(config, "ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY", 7200);
        CommonHazelcastConfig.configCache(config, "ATP_ITF_PENDING_DATA_CONTEXTS", 900);
        CommonHazelcastConfig.configCache(config, "ATP_ITF_RUNNING_SCHEDULED_TASKS");
        CommonHazelcastConfig.configCache(config, "ATP_ITF_AWAITING_CONTEXTS");
        CommonHazelcastConfig.configCache(config, "ATP_ITF_DIAMETER_CONNECTION_INFO", org.qubership.automation.itf.core.util.config.Config.getConfig().getIntOrDefault("diameter.cacheLifetime", 12) * 3600);
        CommonHazelcastConfig.configCache(config, "ATP_ITF_ENVIRONMENT_INFO");
        if (!remoteInstance) {
            CommonHazelcastConfig.configCache(config, "ATP_ITF_PROJECT_SETTINGS", true);
        }
        CommonHazelcastConfig.configCache(config, "ATP_ITF_RESPONSE_MESSAGES");
    }

    private static void configCache(Config config, String cacheName) {
        CommonHazelcastConfig.configCache(config, cacheName, false);
    }

    private static void configCache(Config config, String cacheName, boolean perEntryStatsEnabled) {
        try {
            CommonHazelcastConfig.logTryToCreateInfo(cacheName);
            config.addMapConfig(new MapConfig().setName(cacheName).setPerEntryStatsEnabled(perEntryStatsEnabled));
            CommonHazelcastConfig.logConfigCreatedOrExist(cacheName);
        }
        catch (Exception exception) {
            log.warn("Map {} already created on Hazelcast cluster side. It's not possible to change existing map config.", (Object)cacheName, (Object)exception);
        }
    }

    private static void configCache(Config config, String cacheName, int maxIdleSeconds) {
        try {
            CommonHazelcastConfig.logTryToCreateInfo(cacheName);
            config.addMapConfig(new MapConfig().setName(cacheName).setMaxIdleSeconds(maxIdleSeconds));
            CommonHazelcastConfig.logConfigCreatedOrExist(cacheName);
        }
        catch (Exception exception) {
            log.warn("Map {} already created on Hazelcast cluster side. It's not possible to change existing map config.", (Object)cacheName, (Object)exception);
        }
    }

    private static void logTryToCreateInfo(String cacheName) {
        log.info("Try to create config for hazelcast {} map.", (Object)cacheName);
    }

    private static void logConfigCreatedOrExist(String cacheName) {
        log.info("Config for hazelcast {} map created or already exist with the same parameters.", (Object)cacheName);
    }

    @Bean(name={"hazelcastCacheManager"})
    public CacheManager hazelcastCacheManager(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        ArrayList<ConcurrentMapCache> caches = new ArrayList<ConcurrentMapCache>();
        IMap tcContexts = hazelcastClient.getMap("ATP_ITF_TC_CONTEXTS");
        tcContexts.addEntryListener((MapListener)new TCContextEntryExpiredListener(), true);
        IMap boundContexts = hazelcastClient.getMap("ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY");
        IMap pendingContextData = hazelcastClient.getMap("ATP_ITF_PENDING_DATA_CONTEXTS");
        IMap runningScheduledTasksCacheMap = hazelcastClient.getMap("ATP_ITF_RUNNING_SCHEDULED_TASKS");
        IMap awaitingContexts = hazelcastClient.getMap("ATP_ITF_AWAITING_CONTEXTS");
        IMap environments = hazelcastClient.getMap("ATP_ITF_ENVIRONMENT_INFO");
        IMap diameterConnectionInfo = hazelcastClient.getMap("ATP_ITF_DIAMETER_CONNECTION_INFO");
        IMap projectSettings = hazelcastClient.getMap("ATP_ITF_PROJECT_SETTINGS");
        IMap responseMessages = hazelcastClient.getMap("ATP_ITF_RESPONSE_MESSAGES");
        responseMessages.addEntryListener((MapListener)new ResponseEntryExpiredListener(), true);
        diameterConnectionInfo.addEntryListener((MapListener)new DiameterConnectionInfoEvictedListener(), true);
        caches.add(new ConcurrentMapCache("ATP_ITF_DIAMETER_CONNECTION_INFO", (ConcurrentMap)diameterConnectionInfo, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_TC_CONTEXTS", (ConcurrentMap)tcContexts, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_TC_CONTEXTS_IDS_BOUND_BY_KEY", (ConcurrentMap)boundContexts, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_PENDING_DATA_CONTEXTS", (ConcurrentMap)pendingContextData, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_RUNNING_SCHEDULED_TASKS", (ConcurrentMap)runningScheduledTasksCacheMap, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_AWAITING_CONTEXTS", (ConcurrentMap)awaitingContexts, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_ENVIRONMENT_INFO", (ConcurrentMap)environments, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_PROJECT_SETTINGS", (ConcurrentMap)projectSettings, false));
        caches.add(new ConcurrentMapCache("ATP_ITF_RESPONSE_MESSAGES", (ConcurrentMap)responseMessages, false));
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(caches);
        return cacheManager;
    }
}

