/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.hazelcast;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import org.qubership.automation.itf.executor.cache.hazelcast.CommonHazelcastConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CommonHazelcastConfig.class})
@ConditionalOnProperty(value={"hazelcast.cache.enabled"}, havingValue="true")
public class RemoteHazelcastConfig {
    private static final Logger log = LoggerFactory.getLogger(RemoteHazelcastConfig.class);

    @Bean(name={"hazelcastClient"})
    public HazelcastInstance hazelcastClient(@Qualifier(value="clientConfig") ClientConfig clientConfig) {
        HazelcastInstance hazelcastClient = HazelcastClient.getOrCreateHazelcastClient((ClientConfig)clientConfig);
        CommonHazelcastConfig.tryToCreateMapConfigsIfNotExist(hazelcastClient, true);
        this.addProjectSettingsNearCacheConfig(clientConfig);
        return hazelcastClient;
    }

    public void addProjectSettingsNearCacheConfig(ClientConfig clientConfig) {
        NearCacheConfig projectSettingsNearCacheConfig = clientConfig.getNearCacheConfig("ATP_ITF_PROJECT_SETTINGS");
        if (projectSettingsNearCacheConfig == null) {
            projectSettingsNearCacheConfig = new NearCacheConfig("ATP_ITF_PROJECT_SETTINGS").setInMemoryFormat(InMemoryFormat.OBJECT);
            log.info("Hazelcast Near Cache config ATP_ITF_PROJECT_SETTINGS is created");
        }
        clientConfig.addNearCacheConfig(projectSettingsNearCacheConfig);
    }
}

