/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.cache.service.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.model.jpa.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ResponseCacheService {
    private static final Logger log = LoggerFactory.getLogger(ResponseCacheService.class);
    private HazelcastInstance hazelcastClient;

    @Autowired
    public void setHazelcastClient(@Qualifier(value="hazelcastClient") HazelcastInstance hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    public Message getByKey(String key) {
        return (Message)this.getResponseCache().get((Object)key);
    }

    public void set(String key, String stringTtl, Message message) {
        try {
            long ttl = Long.parseLong(stringTtl);
            this.getResponseCache().set((Object)key, (Object)message, ttl, TimeUnit.SECONDS);
            log.debug("Message {} was set to {} cache.", (Object)key, (Object)"ATP_ITF_RESPONSE_MESSAGES");
        }
        catch (HazelcastSerializationException ex) {
            log.error("Can't serialize Message to set into ATP_ITF_REST_SOAP_RESPONSE_OBJECT.", (Throwable)ex);
        }
        catch (Exception e) {
            log.error("Something went wrong while set Message to {} cache", (Object)"ATP_ITF_RESPONSE_MESSAGES");
        }
    }

    public void evict(String key) {
        this.getResponseCache().evict((Object)key);
    }

    private IMap<Object, Message> getResponseCache() {
        return this.hazelcastClient.getMap("ATP_ITF_RESPONSE_MESSAGES");
    }
}

