/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.config.jms.template;

import java.beans.ConstructorProperties;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

@Configuration
public class TopicJmsTemplateConfiguration {
    private final MessageConverter endSituationsJacksonJmsMessageConverter;
    private final MessageConverter jacksonJmsMessageConverter;
    @Value(value="${message-broker.other-topics.message-time-to-live}")
    private int otherTopicsMessagesTimeToLive;
    @Value(value="${message-broker.end-exceptional-situations-events.message-time-to-live}")
    private int situationEventsTopicMessagesTimeToLive;

    @Bean
    public AtpJmsTemplate topicJmsTemplate(AtpJmsTemplate topicJmsTemplateInstance) {
        topicJmsTemplateInstance.setMessageConverter(this.jacksonJmsMessageConverter);
        topicJmsTemplateInstance.setPubSubDomain(true);
        ((JmsTemplate)topicJmsTemplateInstance).setExplicitQosEnabled(true);
        ((JmsTemplate)topicJmsTemplateInstance).setTimeToLive((long)this.otherTopicsMessagesTimeToLive);
        return topicJmsTemplateInstance;
    }

    @Bean
    public AtpJmsTemplate endSituationsTopicJmsTemplate(AtpJmsTemplate endSituationsTopicJmsTemplateInstance) {
        endSituationsTopicJmsTemplateInstance.setMessageConverter(this.endSituationsJacksonJmsMessageConverter);
        endSituationsTopicJmsTemplateInstance.setPubSubDomain(true);
        ((JmsTemplate)endSituationsTopicJmsTemplateInstance).setExplicitQosEnabled(true);
        ((JmsTemplate)endSituationsTopicJmsTemplateInstance).setTimeToLive((long)this.situationEventsTopicMessagesTimeToLive);
        return endSituationsTopicJmsTemplateInstance;
    }

    @ConstructorProperties(value={"endSituationsJacksonJmsMessageConverter", "jacksonJmsMessageConverter"})
    public TopicJmsTemplateConfiguration(MessageConverter endSituationsJacksonJmsMessageConverter, MessageConverter jacksonJmsMessageConverter) {
        this.endSituationsJacksonJmsMessageConverter = endSituationsJacksonJmsMessageConverter;
        this.jacksonJmsMessageConverter = jacksonJmsMessageConverter;
    }
}

