/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.scheduled;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CleanTmpFileScheduler {
    private static final Logger log = LoggerFactory.getLogger(CleanTmpFileScheduler.class);
    @Value(value="${scheduled.cleanup.tempFiles.modifiedBefore.ms}")
    private int modifiedBeforeMs;

    @Scheduled(fixedRateString="${scheduled.cleanup.tempFiles.fixedRate.ms}")
    public void cleanTempArchiveFiles() {
        log.debug("Scheduled Cleanup of Temp Files Job is started...");
        String rootDirectory = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath().toString();
        Path tempPath = Paths.get(rootDirectory + File.separatorChar + "data_temp", new String[0]);
        Long expirationDate = System.currentTimeMillis() - (long)this.modifiedBeforeMs;
        if (Objects.isNull(tempPath) || !Files.exists(tempPath, new LinkOption[0])) {
            log.warn("Temp directory {} doesn't exist, files will not be removed", (Object)tempPath);
            return;
        }
        ArrayList<String> deletedPaths = new ArrayList<String>();
        this.removeFiles(tempPath, expirationDate, deletedPaths);
        log.debug("Files are removed: {}", deletedPaths);
    }

    private void removeFiles(Path tmpdir, final Long expirationDate, final List<String> deletedPaths) {
        try {
            Files.walkFileTree(tmpdir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = String.valueOf(file.getFileName());
                    if (attrs.lastModifiedTime().toMillis() < expirationDate) {
                        deletedPaths.add(fileName);
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error("Unable to remove archive files from temp directory {}", (Object)tmpdir, (Object)e);
        }
    }
}

