/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.service;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.activemq.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.multitenancy.interceptor.jms.AtpJmsTemplate;
import org.qubership.automation.itf.core.model.communication.message.EventTriggerStateResponse;
import org.qubership.automation.itf.core.model.communication.message.TriggerExecutionMessage;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ExecutorToMessageBrokerSender {
    private static final Logger log = LoggerFactory.getLogger(ExecutorToMessageBrokerSender.class);
    private final AtpJmsTemplate topicJmsTemplate;
    private final AtpJmsTemplate endSituationsTopicJmsTemplate;
    private final AtpJmsTemplate queueJmsTemplate;
    private final AtpJmsTemplate reportsQueueJmsTemplate;
    private final Environment env;
    private final Map<String, AtpJmsTemplate> jmsTemplateMap = new HashMap<String, AtpJmsTemplate>();
    private final String HOSTNAME_MESSAGE_PROPERTY = "hostname";
    @Value(value="${message-broker.executor-stubs-sync.topic}")
    String executorStubsSyncTopic;
    @Value(value="${message-broker.executor-stubs-outgoing-response.queue}")
    String executorStubsOutgoingResponseQueue;
    @Value(value="${message-broker.executor-configurator-event-triggers.topic}")
    String executorConfiguratorEventTriggersTopic;
    @Value(value="${message-broker.eds-update.topic}")
    String externalDataStorageUpdateTopic;
    @Value(value="${message-broker.end-exceptional-situations-events.topic}")
    String endExceptionalSituationsEventsTopic;
    @Value(value="${message-broker.executor-tccontext-operations.topic}")
    String tcContextOperationsTopic;
    @Value(value="${message-broker.executor-disabling-stepbystep.topic}")
    String disablingStepByStepTopic;
    @Value(value="${message-broker.executor-sync-reload-dictionary.topic}")
    String syncReloadDictionaryTopic;
    @Value(value="${message-broker.reports.queue}")
    String reportsIntegrationQueue;

    @PostConstruct
    public void init() {
        this.jmsTemplateMap.put("topic", this.topicJmsTemplate);
        this.jmsTemplateMap.put("queue", this.queueJmsTemplate);
    }

    public void sendMessageToExecutorStubsSyncTopic(String message) {
        this.topicJmsTemplate.convertAndSend(this.executorStubsSyncTopic, (Object)message);
    }

    @AtpJaegerLog
    public void sendMessageToExecutorStubsOutgoingResponseQueue(TriggerExecutionMessage triggerExecutionMessage, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)triggerExecutionMessage.getBrokerMessageSelectorValue())) {
            log.error("SessionId: {}, Response is NOT sent to stubs, due to Broker Message Selector Value is EMPTY!", (Object)triggerExecutionMessage.getSessionId());
            return;
        }
        MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)MDC.get((String)MdcField.STUB_TRACE_ID.toString()));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("X-Project-Id", tenantId);
        properties.put("traceId", MDC.get((String)"traceId"));
        properties.put("hostname", triggerExecutionMessage.getBrokerMessageSelectorValue());
        this.queueJmsTemplate.convertAndSend(this.executorStubsOutgoingResponseQueue, (Object)triggerExecutionMessage, properties);
        log.info("SessionId: {}, Broker Message Selector Value: {}. Response is sent to stubs", (Object)triggerExecutionMessage.getSessionId(), (Object)triggerExecutionMessage.getBrokerMessageSelectorValue());
    }

    public void sendMessageExecutorConfiguratorEventTriggersTopic(EventTriggerStateResponse message, String tenantId) {
        this.topicJmsTemplate.convertAndSend(this.executorConfiguratorEventTriggersTopic, (Object)message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendMessageToExternalDataStorageUpdateTopic(Object message, String tenantId) {
        this.topicJmsTemplate.convertAndSend(this.externalDataStorageUpdateTopic, message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendEventToEndExceptionalSituationsTopic(Object event, String tenantId) {
        this.endSituationsTopicJmsTemplate.convertAndSend(this.endExceptionalSituationsEventsTopic, event, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendMessageToTcContextOperationsTopic(Object message, String tenantId) {
        this.topicJmsTemplate.convertAndSend(this.tcContextOperationsTopic, message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendMessageToDisableStepByStepTopic(Object message, String tenantId) {
        this.topicJmsTemplate.convertAndSend(this.disablingStepByStepTopic, message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendMessageToSyncReloadDictionaryTopic(Object message, String tenantId) {
        this.topicJmsTemplate.convertAndSend(this.syncReloadDictionaryTopic, message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    public void sendMessageToReportingQueue(Object message) {
        this.reportsQueueJmsTemplate.convertAndSend(this.reportsIntegrationQueue, message);
    }

    public void sendMessage(Object message, String queueNameParameterName, String queueType, String tenantId) throws Exception {
        String queueName = this.env.getProperty(queueNameParameterName);
        if (queueName == null) {
            throw new ConfigurationException(String.format("Parameter \"%s\" not found in application.properties", queueNameParameterName));
        }
        AtpJmsTemplate jmsTemplate = this.jmsTemplateMap.get(queueType);
        if (jmsTemplate == null) {
            throw new ConfigurationException(String.format("Type \"%s\" cannot be processed, supported types: \"topic\", \"queue\".", queueType));
        }
        jmsTemplate.convertAndSend(queueName, message, Collections.singletonMap("X-Project-Id", tenantId));
    }

    @ConstructorProperties(value={"topicJmsTemplate", "endSituationsTopicJmsTemplate", "queueJmsTemplate", "reportsQueueJmsTemplate", "env"})
    public ExecutorToMessageBrokerSender(AtpJmsTemplate topicJmsTemplate, AtpJmsTemplate endSituationsTopicJmsTemplate, AtpJmsTemplate queueJmsTemplate, AtpJmsTemplate reportsQueueJmsTemplate, Environment env) {
        this.topicJmsTemplate = topicJmsTemplate;
        this.endSituationsTopicJmsTemplate = endSituationsTopicJmsTemplate;
        this.queueJmsTemplate = queueJmsTemplate;
        this.reportsQueueJmsTemplate = reportsQueueJmsTemplate;
        this.env = env;
    }
}

