/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.transports.classloader;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.Set;
import org.qubership.automation.itf.core.util.loader.base.AbstractLoader;
import org.qubership.automation.itf.core.util.provider.MeansCommunication;
import org.qubership.automation.itf.executor.transports.holder.TransportHolder;

public class TransportClassLoader
extends AbstractLoader<MeansCommunication> {
    private static final TransportClassLoader INSTANCE = new TransportClassLoader();

    private TransportClassLoader() {
        LIB = "/lib";
        PATH_PATTERN = "(mockingbird-transport+[\\w-]*)";
    }

    public static TransportClassLoader getInstance() {
        return INSTANCE;
    }

    public MeansCommunication getInstanceClass(String className, Object ... paramForConstructor) throws ClassNotFoundException {
        try {
            MeansCommunication meansCommunication = TransportHolder.getInstance().checkAvailability(className);
            if (Objects.nonNull(meansCommunication)) {
                return meansCommunication;
            }
            return this.getClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClassNotFoundException("Classloader not found for class", e);
        }
    }

    public Class<? extends MeansCommunication> getClass(String typeName) throws ClassNotFoundException {
        try {
            return this.getClassLoaderHolder().computeIfAbsent(typeName, className -> {
                throw new IllegalArgumentException("Classloader not found for class " + typeName);
            }).loadClass(typeName).asSubclass(MeansCommunication.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class with type name '" + typeName + "' is not found in classloader", e);
        }
    }

    protected Class<MeansCommunication> getGenericType() {
        return MeansCommunication.class;
    }

    protected void validateClasses(Set<Class<? extends MeansCommunication>> classes) {
        if (!classes.iterator().hasNext()) {
            throw new IllegalArgumentException("No one class found");
        }
    }
}

