/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.executor.transports.registry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.rmi.RemoteException;
import javax.annotation.Nonnull;
import org.qubership.automation.itf.core.util.config.ApplicationConfig;
import org.qubership.automation.itf.core.util.exception.ExportException;
import org.qubership.automation.itf.core.util.exception.NoDeployedTransportException;
import org.qubership.automation.itf.core.util.provider.MeansCommunication;
import org.qubership.automation.itf.core.util.transport.access.AccessTransport;
import org.qubership.automation.itf.core.util.transport.base.InboundTransport;
import org.qubership.automation.itf.core.util.transport.base.OutboundTransport;
import org.qubership.automation.itf.core.util.transport.loader.LoaderInboundTransportImpl;
import org.qubership.automation.itf.core.util.transport.loader.LoaderOutboundTransportImpl;
import org.qubership.automation.itf.core.util.transport.registry.base.AbstractTransportRegistry;
import org.qubership.automation.itf.executor.transports.classloader.TransportClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRegistryLoader
extends AbstractTransportRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportRegistryLoader.class);
    private static final String TRANSPORT_FOLDER = "transport.folder";
    private static final String TRANSPORT_LIB = "transport.lib";
    private TransportClassLoader loader;
    private final LoadingCache<String, AccessTransport> transportCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AccessTransport>(){

        public AccessTransport load(@Nonnull String transportType) throws Exception {
            MeansCommunication instanceClass = TransportRegistryLoader.this.loader.getInstanceClass(transportType, new Object[0]);
            if (instanceClass instanceof InboundTransport) {
                return new LoaderInboundTransportImpl((InboundTransport)instanceClass);
            }
            if (instanceClass instanceof OutboundTransport) {
                return new LoaderOutboundTransportImpl((OutboundTransport)instanceClass);
            }
            throw new NoDeployedTransportException(transportType + " is not loaded");
        }
    });

    public void init() throws ExportException {
        if (this.loader == null) {
            this.loader = TransportClassLoader.getInstance();
            LOGGER.info("Transport registry is ready");
        }
        this.loader.load(ApplicationConfig.env.getProperty(TRANSPORT_FOLDER), ApplicationConfig.env.getProperty(TRANSPORT_LIB));
    }

    protected void protectedRegister(AccessTransport accessTransport) {
    }

    protected void protectedUnregister(String s) throws RemoteException {
    }

    protected AccessTransport protectedFind(String typeName) throws RemoteException {
        try {
            return this.isLoaded() ? (AccessTransport)this.transportCache.getIfPresent((Object)typeName) : (AccessTransport)this.transportCache.get((Object)typeName);
        }
        catch (Exception e) {
            throw new RemoteException("", e);
        }
    }

    public void destroy() {
        this.loader.cleanClassLoaders();
    }
}

