/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.execution;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.qubership.automation.itf.core.execution.ExecutorServiceProvider;
import org.qubership.automation.itf.core.execution.WaitTimeMonitoringThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutorServiceProvider
implements ExecutorServiceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorServiceProvider.class);
    private static final Thread.UncaughtExceptionHandler HANDLER = (t, e) -> LOGGER.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e);
    private final BlockingQueue<Runnable> regularQueue;
    private final BlockingQueue<Runnable> backgroundQueue;
    private final SynchronousQueue<Runnable> inboundQueue;
    private final ExecutorService backgroundPool;
    private final ExecutorService regularPool;
    private final ExecutorService inboundPool;

    public DefaultExecutorServiceProvider(int executorThreadPoolCoreSize, int executorThreadPoolSize, int backgroundExecutorThreadPoolSize) {
        ThreadFactory regularThreadFactory = new ThreadFactoryBuilder().setNameFormat("rpt-%d").setDaemon(false).setPriority(5).setUncaughtExceptionHandler(HANDLER).build();
        if (executorThreadPoolCoreSize < executorThreadPoolSize) {
            int coreSize = executorThreadPoolCoreSize < 1 ? 5 : executorThreadPoolCoreSize;
            this.regularQueue = new SynchronousQueue<Runnable>();
            this.regularPool = new WaitTimeMonitoringThreadPoolExecutor(coreSize, executorThreadPoolSize, 60L, TimeUnit.SECONDS, this.regularQueue, regularThreadFactory);
        } else {
            this.regularQueue = new LinkedBlockingQueue<Runnable>();
            this.regularPool = new WaitTimeMonitoringThreadPoolExecutor(executorThreadPoolSize, executorThreadPoolSize, 60L, TimeUnit.SECONDS, this.regularQueue, regularThreadFactory);
        }
        this.backgroundQueue = new LinkedBlockingQueue<Runnable>();
        this.backgroundPool = new WaitTimeMonitoringThreadPoolExecutor(backgroundExecutorThreadPoolSize, backgroundExecutorThreadPoolSize, 120L, TimeUnit.SECONDS, this.backgroundQueue, new ThreadFactoryBuilder().setNameFormat("bpt-%d").setDaemon(false).setPriority(5).setUncaughtExceptionHandler(HANDLER).build());
        this.inboundQueue = new SynchronousQueue();
        this.inboundPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 20L, TimeUnit.SECONDS, this.inboundQueue, new ThreadFactoryBuilder().setNameFormat("ipt-%d").setDaemon(false).setPriority(6).setUncaughtExceptionHandler(HANDLER).build());
    }

    @Override
    public ExecutorService requestForBackgroundJob() {
        return this.backgroundPool;
    }

    @Override
    public ExecutorService requestForRegular() {
        return this.regularPool;
    }

    @Override
    public ExecutorService requestForInboundProcessing() {
        return this.inboundPool;
    }

    public BlockingQueue<Runnable> getRegularQueue() {
        return this.regularQueue;
    }

    public BlockingQueue<Runnable> getBackgroundQueue() {
        return this.backgroundQueue;
    }

    public SynchronousQueue<Runnable> getInboundQueue() {
        return this.inboundQueue;
    }

    @Override
    public void shutdown() {
        this.backgroundPool.shutdownNow();
        this.regularPool.shutdownNow();
        this.inboundPool.shutdownNow();
    }
}

