/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.situation;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.LazyInitializationException;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.automation.itf.core.instance.situation.TCContextDiffCache;
import org.qubership.automation.itf.core.instance.step.StepExecutorFactory;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.NextCallChainEventSubscriberHolder;
import org.qubership.automation.itf.core.instance.testcase.execution.holders.SubscriberData;
import org.qubership.automation.itf.core.model.common.Storable;
import org.qubership.automation.itf.core.model.condition.ConditionsHelper;
import org.qubership.automation.itf.core.model.container.StepContainer;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.NextCallChainEvent;
import org.qubership.automation.itf.core.model.event.SituationEvent;
import org.qubership.automation.itf.core.model.event.StepEvent;
import org.qubership.automation.itf.core.model.jpa.context.InstanceContext;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.context.TcContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractContainerInstance;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.SituationInstance;
import org.qubership.automation.itf.core.model.jpa.instance.chain.CallChainInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.qubership.automation.itf.core.model.jpa.system.operation.Operation;
import org.qubership.automation.itf.core.model.jpa.system.stub.Listener;
import org.qubership.automation.itf.core.model.jpa.system.stub.Situation;
import org.qubership.automation.itf.core.model.jpa.system.stub.SituationEventTrigger;
import org.qubership.automation.itf.core.regenerator.KeysRegenerator;
import org.qubership.automation.itf.core.report.ReportIntegration;
import org.qubership.automation.itf.core.util.FlatMapUtil;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.constants.SituationLevelValidation;
import org.qubership.automation.itf.core.util.constants.StartedFrom;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.engine.TemplateEngine;
import org.qubership.automation.itf.core.util.engine.TemplateEngineFactory;
import org.qubership.automation.itf.core.util.exception.EngineIntegrationException;
import org.qubership.automation.itf.core.util.exception.IncomingValidationException;
import org.qubership.automation.itf.core.util.generator.id.UniqueIdGenerator;
import org.qubership.automation.itf.core.util.holder.EventTriggerHolder;
import org.qubership.automation.itf.core.util.iterator.StepIterator;
import org.qubership.automation.itf.core.util.manager.CoreObjectManager;
import org.qubership.automation.itf.core.util.mdc.MdcField;
import org.qubership.automation.itf.core.util.report.ReportLinkCollector;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.cache.service.CacheServices;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.qubership.automation.itf.executor.service.ExecutionServices;
import org.qubership.automation.itf.executor.service.ExecutorToMessageBrokerSender;
import org.qubership.automation.itf.executor.service.ProjectSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class SituationExecutorService {
    private static final Logger log = LoggerFactory.getLogger(SituationExecutorService.class);
    private final TemplateEngine templateEngine;
    private final ReportLinkCollector reportLinkCollector;
    private final ExecutorToMessageBrokerSender executorToMessageBrokerSender;
    private final EventBusProvider eventBusProvider;
    private final StepExecutorFactory stepExecutorFactory;
    private final ProjectSettingsService projectSettingsService;

    public void executeInstance(SituationInstance instance, Storable source, SpContext spContext, NextCallChainEvent event) {
        this.executeInstance(instance, source, spContext, event, instance.getSituationById());
    }

    @AtpJaegerLog(spanTags={@AtpSpanTag(key="execute.situation.instance.id", value="#instance.situationId.toString()")})
    public void executeInstance(SituationInstance instance, Storable source, SpContext spContext, NextCallChainEvent event, Situation situation) {
        MdcUtils.put((String)MdcField.TRACE_ID.toString(), (String)MDC.get((String)MdcField.STUB_TRACE_ID.toString()));
        this.executeInstance(instance, source, spContext, event, situation, situation.getParent());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeInstance(SituationInstance instance, Storable source, SpContext spContext, NextCallChainEvent event, Situation situation, Operation parentOperation) {
        this.fillParentsInfo(instance, situation, parentOperation);
        instance.setParentContext(this.prepareAndStartTcContextIfNeeded(instance));
        this.executeOnStartSituationTrigger(instance, situation);
        HashMap<String, Object> leftFlatMap = StartedFrom.RAM2.equals((Object)instance.getContext().getTC().getStartedFrom()) ? FlatMapUtil.flatten((Map)instance.getContext().getTC()) : new HashMap();
        instance.setStatus(Status.IN_PROGRESS);
        instance.setStartTime(new Date());
        instance.setName(TemplateEngineFactory.process((Storable)instance.getStepContainer(), (String)situation.getName(), (JsonContext)instance.getContext(), (String)"Situation name"));
        SituationEvent.Start startSituationEvent = new SituationEvent.Start(instance);
        startSituationEvent.setSource(source);
        this.eventBusProvider.post((Event)startSituationEvent);
        boolean firstRun = true;
        while (true) {
            try {
                this.executeInstanceStep(instance, spContext, event, situation, firstRun, parentOperation);
                this.computeContextDiff(leftFlatMap, instance.getContext().getTC(), instance.getID());
                return;
            }
            catch (EngineIntegrationException e) {
                boolean needRetryIntegrationStep = this.checkNeedRetryIntegrationStep(instance);
                this.retryPause(instance, !needRetryIntegrationStep);
                if (needRetryIntegrationStep) {
                    this.failureOfSituationWithoutAtpReport(instance, (Exception)((Object)e));
                } else {
                    this.performPostCalculations(situation, instance, ((StepInstance)instance.getStepInstances().get(instance.getStepInstances().size() - 1)).getContext(), true);
                    this.computeContextDiff(leftFlatMap, instance.getContext().getTC(), instance.getID());
                    this.postStepEventFinishIfIsRetryStep(instance);
                    this.failureOfSituation(instance, (Exception)((Object)e), "Failed message validation");
                }
                if (event != null) {
                    if (needRetryIntegrationStep) {
                        instance.setIterator(null);
                        firstRun = false;
                        continue;
                    }
                    if (situation.getValidateIncoming() == SituationLevelValidation.FAIL) {
                        this.postEventException(e.getShortMessage(), event);
                        return;
                    }
                    this.postResumeEventWithContinueTc(event);
                    return;
                }
                this.failTCByException(instance, (Exception)((Object)e));
                return;
            }
            catch (IncomingValidationException e) {
                this.computeContextDiff(leftFlatMap, instance.getContext().getTC(), instance.getID());
                if (situation.getValidateIncoming() == SituationLevelValidation.FAIL) {
                    this.failTCByException(instance, (Exception)((Object)e));
                    if (instance.getContext().tc().getInitiator() instanceof SituationInstance) throw new RuntimeException("Exception while preparing a response for inbound message", e.getCause() instanceof EngineIntegrationException ? e.getCause() : e);
                    continue;
                }
                this.failureOfSituation(instance, (Exception)((Object)e), e.getMessage());
                throw new IncomingValidationException(e.getMessage());
            }
            catch (Exception e) {
                this.computeContextDiff(leftFlatMap, instance.getContext().getTC(), instance.getID());
                this.failTCByException(instance, e);
                if (!(instance.getContext().tc().getInitiator() instanceof SituationInstance)) return;
                throw new RuntimeException("Exception while preparing a response for inbound message", e.getCause() instanceof EngineIntegrationException ? e.getCause() : e);
            }
            break;
        }
    }

    private void executeOnStartSituationTrigger(SituationInstance instance, Situation situation) {
        List listeners = EventTriggerHolder.getInstance().getOnStartSituationListeners(situation.getID());
        if (Objects.isNull(listeners) || listeners.isEmpty()) {
            return;
        }
        for (Listener listener : listeners) {
            log.debug("Get SituationEventTrigger from DB by id - started");
            this.executeByTrigger((SituationEventTrigger)CoreObjectManager.getInstance().getManager(SituationEventTrigger.class).getById(listener.getId()), instance);
        }
    }

    private void fillParentsInfo(SituationInstance instance, Situation situation, Operation parentOperation) {
        instance.setSituationId((BigInteger)situation.getID());
        if (parentOperation != null) {
            instance.setOperationName(parentOperation.getName());
            instance.setOperationId((BigInteger)parentOperation.getID());
            instance.setSystemName(parentOperation.getParent().getName());
            instance.setSystemId((BigInteger)parentOperation.getParent().getID());
        }
    }

    private void performPostCalculations(Situation situation, SituationInstance instance, InstanceContext lastExecutedStepInstanceContext, boolean onlyLogException) {
        try {
            if (!StringUtils.isBlank((CharSequence)situation.getPostScript())) {
                this.templateEngine.process((Storable)situation, situation.getPostScript(), (JsonContext)lastExecutedStepInstanceContext, "post-script on the situation");
            }
            this.setParsedName(instance, situation.getName(), lastExecutedStepInstanceContext);
        }
        catch (Exception parsingException) {
            if (onlyLogException) {
                log.warn("Instance {}: an exception occurred while post-script is executed.", (Object)instance, (Object)parsingException);
            }
            throw new RuntimeException("An exception occurred while post-script is executed:", parsingException);
        }
    }

    private void computeContextDiff(Map<String, Object> leftFlatMap, TcContext currentContext, Object id) {
        if (StartedFrom.RAM2.equals((Object)currentContext.getStartedFrom())) {
            Map rightFlatMap = FlatMapUtil.flatten((Map)currentContext);
            MapDifference difference = Maps.difference(leftFlatMap, (Map)rightFlatMap);
            TCContextDiffCache.TC_CONTEXT_DIFF_CACHE.put((Object)id.toString(), (Object)difference);
        }
    }

    private TcContext prepareAndStartTcContextIfNeeded(SituationInstance instance) {
        TcContext tcContext = instance.getContext().tc();
        if (tcContext.getInitiator() == null) {
            tcContext.setInitiator((AbstractContainerInstance)instance);
            tcContext.setName(instance.getName());
            this.reportLinkCollector.collect(tcContext);
        }
        if (!tcContext.isRunning() && tcContext.isRunnable()) {
            ExecutionServices.getTCContextService().start(tcContext);
        }
        return tcContext;
    }

    private boolean isInboundRequestOnlyOrInboundSync(Mep mep) {
        return mep.isInbound() && (mep.isRequest() && !mep.isResponse() || mep.isSync());
    }

    private boolean executePreScriptAtFirstRun(Situation situation, InstanceContext instanceContext, boolean firstRun) {
        instanceContext.tc().putIfAbsent((Object)"saved", (Object)new JsonContext());
        if (firstRun && !StringUtils.isBlank((CharSequence)situation.getPreScript())) {
            this.templateEngine.process((Storable)situation, situation.getPreScript(), (JsonContext)instanceContext, "pre-script on the situation");
            return false;
        }
        return firstRun;
    }

    private InstanceContext checkForNullContext(StepInstance lastExecutedStepInstance, SituationInstance instance) {
        return lastExecutedStepInstance == null ? instance.getContext() : lastExecutedStepInstance.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void executeInstanceStep(SituationInstance instance, SpContext spContext, NextCallChainEvent event, Situation situation, boolean firstRun, Operation parentOperation) throws Exception {
        tcContext = instance.getContext().tc();
        SituationExecutorService.log.debug("regenerateKeys - started");
        try {
            KeysRegenerator.getInstance().regenerateKeys(instance.getContext(), situation.getKeysToRegenerate());
        }
        catch (LazyInitializationException e) {
            SituationExecutorService.log.error("regenerateKeys - error", (Throwable)e);
            situation = (Situation)CoreObjectManager.getInstance().getManager(Situation.class).getById(situation.getID());
            KeysRegenerator.getInstance().regenerateKeys(instance.getContext(), situation.getKeysToRegenerate());
        }
        SituationExecutorService.log.debug("regenerateKeys - finished");
        lastExecutedStepInstance = null;
        needRunPreScript = firstRun;
        inboundRequestOrSync = this.isInboundRequestOnlyOrInboundSync(parentOperation.getMep());
        if (inboundRequestOrSync) {
            SituationExecutorService.log.info("Execution of inbound situation {}", (Object)situation);
            stepInstance = this.createInbound(instance, spContext, parentOperation);
            spContext = stepInstance.getContext().sp();
            needRunPreScript = this.executePreScriptAtFirstRun(situation, stepInstance.getContext(), needRunPreScript);
            this.recalculateInboundContextName(instance, this.checkForNullContext(stepInstance, instance));
            clientAddressContextVariable = this.projectSettingsService.get(tcContext.getProjectId(), "tc.context.client_address", "");
            if (!StringUtils.isBlank((CharSequence)clientAddressContextVariable)) {
                instance.getContext().tc().setClient(this.templateEngine.process((Storable)situation, clientAddressContextVariable, (JsonContext)stepInstance.getContext(), "'Client' context variable"));
            }
            try {
                this.validateIncomingMessage(instance, stepInstance.getContext(), situation);
            }
            catch (Exception ex) {
                if (situation.getValidateIncoming() != SituationLevelValidation.IGNORE) {
                    throw ex;
                }
            }
            finally {
                this.stepExecutorFactory.execute(stepInstance);
                lastExecutedStepInstance = stepInstance;
                if (parentOperation.getMep().isSync()) {
                    this.addHeadersInTC(spContext.getIncomingMessage().getHeaders(), stepInstance.getContext().getTC());
                }
                this.checkErrorsAndValidationLevel(instance, situation);
            }
        }
        for (StepInstance stepInstance : instance) {
            stepInstance.setID((Object)UniqueIdGenerator.generate());
            if (spContext != null) {
                stepInstance.getContext().sp().putAll((Map)spContext);
            }
            stepInstance.setIsRetryStep(this.isRetryOnFailStep(stepInstance));
            needRunPreScript = this.executePreScriptAtFirstRun(situation, stepInstance.getContext(), needRunPreScript);
            try {
                this.stepExecutorFactory.execute(stepInstance);
            }
            catch (Exception ex) {
                if (situation.isIgnoreErrors()) continue;
                throw ex;
            }
            finally {
                this.recalculateInboundContextName(instance, this.checkForNullContext(stepInstance, instance));
                lastExecutedStepInstance = stepInstance;
                if (!stepInstance.isRetryStep()) continue;
                this.addCurrentValidStepAttemptValueAndStartTime(instance);
            }
        }
        ExecutionServices.getTCContextService().updateLastAccess(tcContext);
        if (!inboundRequestOrSync && tcContext.isStartValidation()) {
            if (tcContext.getInitiator() instanceof SituationInstance) {
                try {
                    this.validateIncomingMessage(instance, this.checkForNullContext(lastExecutedStepInstance, instance), situation);
                }
                catch (Exception ex) {
                    if (situation.getValidateIncoming() == SituationLevelValidation.IGNORE) ** GOTO lbl70
                    throw ex;
                }
                finally {
                    this.eventBusProvider.post((Event)new StepEvent.Finish(lastExecutedStepInstance));
                    this.checkErrorsAndValidationLevel(instance, situation);
                }
            } else {
                this.messageValidation(instance, this.checkForNullContext(lastExecutedStepInstance, instance), situation);
            }
        }
lbl70:
        // 5 sources

        this.performPostCalculations(situation, instance, this.checkForNullContext(lastExecutedStepInstance, instance), false);
        this.recalculateInboundContextName(instance, this.checkForNullContext(lastExecutedStepInstance, instance));
        this.postStepEventFinishIfIsRetryStep(instance);
        instance.setStatus(Status.PASSED);
        instance.setEndTime(new Date());
        listStepInstance = instance.getStepInstances();
        stepInstance = (StepInstance)listStepInstance.get(listStepInstance.size() - 1);
        if (this.isRetryOnFailStep(stepInstance)) {
            stepInstance.setName(this.reportValidationAttemptsCount(stepInstance));
        }
        SituationExecutorService.log.info("Situation {} executed", (Object)instance);
        this.eventBusProvider.post((Event)new SituationEvent.Finish(instance));
        this.sendEndExceptionalSituationFinishEvent(tcContext, instance);
        if (event != null) {
            eventInstanceContext = ((CallChainInstance)event.getInstance()).getContext().tc();
            if (eventInstanceContext == null) {
                eventInstanceContext = new TcContext();
            }
            eventInstanceContext.merge((Map)tcContext);
            this.eventBusProvider.post((Event)event);
        }
        if (this.checkIsStub(situation)) {
            if (instance.getErrorMessage() != null) {
                if (situation.getValidateIncoming() == SituationLevelValidation.IGNORE) {
                    ExecutionServices.getTCContextService().finish(tcContext);
                } else {
                    ExecutionServices.getTCContextService().fail(tcContext);
                }
            } else {
                ExecutionServices.getTCContextService().finish(tcContext);
            }
        } else if (inboundRequestOrSync) {
            ExecutionServices.getTCContextService().updateInfo(tcContext);
        }
    }

    private void recalculateInboundContextName(SituationInstance instance, InstanceContext instanceContext) {
        TcContext tcContext = instance.getContext().tc();
        if (tcContext.getInitiator() instanceof SituationInstance && tcContext.getName().contains("$")) {
            try {
                String s = this.templateEngine.process((Storable)instance, tcContext.getName(), (JsonContext)instanceContext, "TcContext name");
                tcContext.setName(s);
            }
            catch (Exception ex) {
                log.warn("TcContext name recalculation is failed for id={}, name='{}'", tcContext.getID(), (Object)tcContext.getName());
            }
        }
    }

    private void setParsedName(SituationInstance instance, String configuredName, InstanceContext instanceContext) {
        String parsedName = TemplateEngineFactory.process((Storable)instance.getStepContainer(), (String)configuredName, (JsonContext)instanceContext, (String)"Situation name");
        if (!StringUtils.isBlank((CharSequence)parsedName)) {
            instance.setName(parsedName);
        }
    }

    private void checkErrorsAndValidationLevel(SituationInstance instance, Situation situation) {
        SituationLevelValidation validationLevel = situation.getValidateIncoming();
        if (!validationLevel.equals((Object)SituationLevelValidation.WARNING) && !validationLevel.equals((Object)SituationLevelValidation.IGNORE) && instance.getError() != null) {
            throw new IncomingValidationException(instance.getErrorMessage());
        }
    }

    private void validateIncomingMessage(SituationInstance instance, InstanceContext instanceContext, Situation situation) throws Exception {
        block2: {
            try {
                this.messageValidation(instance, instanceContext, situation);
            }
            catch (EngineIntegrationException e) {
                SituationLevelValidation validationLevel = situation.getValidateIncoming();
                if (!validationLevel.equals((Object)SituationLevelValidation.WARNING) && !validationLevel.equals((Object)SituationLevelValidation.IGNORE) && !validationLevel.equals((Object)SituationLevelValidation.FAIL)) break block2;
                instance.setError((Throwable)new EngineIntegrationException(e.getMessage()));
            }
        }
    }

    private boolean checkIsStub(Situation situation) {
        Operation operation;
        IntegrationStep integrationStep = situation.getIntegrationStep();
        String isStub = integrationStep == null ? ((operation = situation.getParent()) == null ? null : (String)operation.getTransport().getConfiguration().get("isStub")) : (String)integrationStep.getOperation().getTransport().getConfiguration().get("isStub");
        return isStub != null && isStub.equals("Yes");
    }

    private boolean checkNeedRetryIntegrationStep(SituationInstance instance) {
        List listStepInstance = instance.getStepInstances();
        StepInstance stepInstance = (StepInstance)listStepInstance.get(listStepInstance.size() - 1);
        if (stepInstance.getStep() instanceof IntegrationStep) {
            IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
            if (integrationStep.isRetryOnFail()) {
                stepInstance.setEndTime(new Date());
                if (integrationStep.getValidationMaxTime() != 0L) {
                    long timePassed = integrationStep.retrieveValidationUnitMaxTime().convert(this.countPassedTime(stepInstance), TimeUnit.MILLISECONDS);
                    if (this.isTimeExpired(integrationStep, timePassed)) {
                        stepInstance.setName(this.reportValidationAttemptsCount(stepInstance));
                        return false;
                    }
                } else if (this.areAttemptsExpired(stepInstance)) {
                    stepInstance.setName(this.reportValidationAttemptsCount(stepInstance));
                    return false;
                }
                return true;
            }
            return false;
        }
        log.error("Trying to 'retryIntegrationStep' but it's not a IntegrationStep: {}", (Object)stepInstance);
        return false;
    }

    private String reportValidationAttemptsCount(StepInstance stepInstance) {
        return stepInstance.getName() + " (attempts count: " + stepInstance.getCurrentValidAttemptValue() + ")";
    }

    private void addCurrentValidStepAttemptValueAndStartTime(SituationInstance instance) {
        List listStepInstance = instance.getStepInstances();
        StepInstance lastStepInstance = (StepInstance)listStepInstance.get(listStepInstance.size() - 1);
        if (listStepInstance.size() > 1) {
            StepInstance secondToLastStepInstance = (StepInstance)listStepInstance.get(listStepInstance.size() - 2);
            lastStepInstance.setCurrentValidAttemptValue(secondToLastStepInstance.getCurrentValidAttemptValue() + 1);
            lastStepInstance.setStartTime(secondToLastStepInstance.getStartTime());
            listStepInstance.remove(0);
        } else {
            lastStepInstance.setCurrentValidAttemptValue(lastStepInstance.getCurrentValidAttemptValue() + 1);
        }
    }

    private boolean isRetryOnFailStep(StepInstance stepInstance) {
        IntegrationStep integrationStep;
        boolean result = false;
        if (stepInstance.getStep() instanceof IntegrationStep && (integrationStep = (IntegrationStep)stepInstance.getStep()).isRetryOnFail()) {
            result = true;
        }
        return result;
    }

    private void retryPause(SituationInstance instance, boolean isLastRetry) {
        StepIterator iterator = instance.iterator();
        StepInstance stepInstance = iterator.current();
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        if (!integrationStep.isRetryOnFail()) {
            return;
        }
        long retryTimeout = integrationStep.getRetryTimeout();
        if (retryTimeout > 0L && !StringUtils.isBlank((CharSequence)integrationStep.getRetryTimeoutUnit())) {
            String timeUnit = integrationStep.getRetryTimeoutUnit().toLowerCase();
            if (isLastRetry) {
                Report.info((AbstractInstance)instance, (String)String.format("Pause %d %s after each [%s] (count: %d)", retryTimeout, timeUnit, instance.getName(), stepInstance.getCurrentValidAttemptValue() - 1), (String)String.format("Waiting for [%d] %s", retryTimeout, timeUnit));
            } else {
                try {
                    log.info("{}: waiting for timeout '{}' {}...", new Object[]{instance, retryTimeout, timeUnit});
                    Thread.sleep(integrationStep.retrieveRetryTimeoutUnit().toMillis(retryTimeout));
                }
                catch (InterruptedException e) {
                    this.failureOfSituation(instance, e, "Interrupted Exception");
                }
            }
        }
    }

    private long countPassedTime(StepInstance stepInstance) {
        return new Date().getTime() - stepInstance.getStartTime().getTime();
    }

    private boolean isTimeExpired(IntegrationStep integrationStep, long timePassed) {
        return integrationStep.getValidationMaxTime() - timePassed < 0L;
    }

    private boolean areAttemptsExpired(StepInstance stepInstance) {
        IntegrationStep integrationStep = (IntegrationStep)stepInstance.getStep();
        return integrationStep.getValidationMaxAttempts() != 0 && stepInstance.getCurrentValidAttemptValue() >= integrationStep.getValidationMaxAttempts();
    }

    private void failTCByException(SituationInstance instance, Exception e) {
        this.failureOfSituation(instance, e, "Failed situation");
        if (instance.getContext().tc().getInitiator() != null) {
            this.failOfInitiator(instance.getContext().tc().getInitiator(), instance.getContext().tc(), e);
        }
        this.failureOfTC(instance);
    }

    private void failOfInitiator(AbstractContainerInstance initiator, TcContext tcContext, @Nonnull Exception e) {
        SubscriberData subscriberData;
        initiator.setStatus(Status.FAILED);
        initiator.setErrorName(e.getMessage());
        if (e.getCause() != null) {
            initiator.setErrorMessage(e.getCause().toString());
        }
        if ((subscriberData = NextCallChainEventSubscriberHolder.getInstance().getSubscriberData(tcContext.getID())) != null) {
            NextCallChainEvent.Exception exception = new NextCallChainEvent.Exception(subscriberData.getParentSubscriberId(), null, e.getCause() == null ? ExceptionUtils.getStackTrace((Throwable)e) : e.getCause().toString());
            exception.setID(subscriberData.getSubscriberId());
            this.eventBusProvider.post((Event)exception);
        }
    }

    private void postEventException(String msg, NextCallChainEvent event) {
        NextCallChainEvent.Exception exception = new NextCallChainEvent.Exception(event.getParentId(), (CallChainInstance)event.getInstance(), msg);
        exception.setID(event.getID());
        this.eventBusProvider.post((Event)exception);
    }

    private void postResumeEventWithContinueTc(NextCallChainEvent event) {
        NextCallChainEvent.ResumeStepWithContinueTc resume = new NextCallChainEvent.ResumeStepWithContinueTc(event.getParentId(), (CallChainInstance)event.getInstance());
        resume.setID(event.getID());
        this.eventBusProvider.post((Event)resume);
    }

    private void failureOfTC(SituationInstance instance) {
        TcContext tcContext = instance.getContext().tc();
        ExecutionServices.getTCContextService().fail(tcContext);
    }

    private StepInstance getLastStepInstance(SituationInstance instance) {
        List listStepInstance = instance.getStepInstances();
        return (StepInstance)listStepInstance.get(listStepInstance.size() - 1);
    }

    private void postStepEventFinishIfIsRetryStep(SituationInstance instance) {
        StepInstance lastStepInstance = this.getLastStepInstance(instance);
        if (lastStepInstance.isRetryStep()) {
            this.eventBusProvider.post((Event)new StepEvent.Finish(lastStepInstance));
        }
    }

    private void failureOfSituation(SituationInstance instance, Exception e, String message) {
        this.failureInstance(instance, e, message);
        this.eventBusProvider.post((Event)new SituationEvent.Terminate(instance));
    }

    private void failureOfSituationWithoutAtpReport(SituationInstance instance, Exception e) {
        log.warn("Failed message validation at the {}, Error: {}", (Object)instance, (Object)(e instanceof EngineIntegrationException ? ((EngineIntegrationException)((Object)e)).getShortMessage() : e.getMessage()));
        instance.setStatus(Status.FAILED);
        instance.setEndTime(new Date());
    }

    private void failureInstance(SituationInstance instance, Exception e, String message) {
        log.error("{} at the {}, Error: {}", new Object[]{message, instance, e instanceof EngineIntegrationException ? ((EngineIntegrationException)((Object)e)).getShortMessage() : e.getMessage()});
        instance.setError((Throwable)e);
        instance.setStatus(Status.FAILED);
        instance.setEndTime(new Date());
    }

    private void messageValidation(SituationInstance instance, InstanceContext lastExecutedStepInstanceContext, Situation situation) throws Exception {
        if (situation.getBooleanValidateIncoming()) {
            if (!StringUtils.isBlank((CharSequence)situation.getPreValidationScript())) {
                this.templateEngine.process((Storable)situation, situation.getPreValidationScript(), (JsonContext)lastExecutedStepInstanceContext, "pre-validation script on the situation");
            }
            this.validationInIntegration(instance, lastExecutedStepInstanceContext.sp(), instance.getContext().getTC().getInitiator(), situation);
        }
    }

    private void validationInIntegration(SituationInstance instance, SpContext spContext, AbstractContainerInstance initiator, Situation situation) throws Exception {
        if ((initiator instanceof CallChainInstance || initiator instanceof SituationInstance) && !ReportIntegration.getInstance().runOnStepIntegrations(instance, spContext, initiator, situation)) {
            throw new EngineIntegrationException(initiator.getErrorName(), initiator.getErrorMessage());
        }
    }

    public SituationInstance prepare(Situation situation, InstanceContext context) throws Exception {
        log.info("Preparing instance for situation {}...", (Object)situation);
        SituationInstance instance = new SituationInstance();
        log.debug("UniqueIdGenerator.generate - started");
        instance.setID((Object)UniqueIdGenerator.generate());
        log.debug("UniqueIdGenerator.generate - finished");
        instance.setStepContainer((StepContainer)situation);
        instance.setName(situation.getName());
        instance.getContext().setTC(context.tc());
        instance.getContext().setProjectId(context.getProjectId());
        instance.getContext().setProjectUuid(context.getProjectUuid());
        if (Objects.nonNull(context.getSessionId())) {
            instance.getContext().setSessionId(context.getSessionId());
        }
        if (Objects.nonNull(context.getMessageBrokerSelectorValue())) {
            instance.getContext().setMessageBrokerSelectorValue(context.getMessageBrokerSelectorValue());
        }
        if (Objects.nonNull(context.getTransport())) {
            instance.getContext().setTransport(context.getTransport());
        }
        if (Objects.nonNull(context.getConnectionProperties())) {
            instance.getContext().setConnectionProperties(context.getConnectionProperties());
        }
        if (Objects.nonNull(context.sp())) {
            SpContext spContext = new SpContext();
            spContext.putAll((Map)context.sp());
            instance.getContext().setSP(spContext);
        }
        return instance;
    }

    public void execute(Situation situation, InstanceContext context) throws Exception {
        this.execute(situation, context, null, null);
    }

    public void execute(Situation situation, InstanceContext context, @Nullable Storable source, NextCallChainEvent event) throws Exception {
        if (Objects.nonNull(situation)) {
            SituationInstance instance = this.prepare(situation, context);
            this.executeInstance(instance, source, context.sp(), event, situation);
        }
    }

    private StepInstance createInbound(SituationInstance instance, SpContext spContext, Operation parentOperation) {
        IntegrationStep step = new IntegrationStep();
        step.setOperation(parentOperation);
        step.setReceiver(parentOperation.getParent());
        step.setName(String.format("[%s] receives [%s]", step.getReceiver().getName(), step.getOperation().getName()));
        StepInstance stepInstance = new StepInstance();
        stepInstance.setParent(null);
        stepInstance.setID((Object)UniqueIdGenerator.generate());
        stepInstance.init((Step)step, instance.getContext(), spContext);
        stepInstance.getContext().setProjectId(stepInstance.getContext().tc().getProjectId());
        stepInstance.getContext().setProjectUuid(stepInstance.getContext().tc().getProjectUuid());
        stepInstance.setParent((AbstractInstance)instance);
        stepInstance.setName(step.getName());
        return stepInstance;
    }

    private void addHeadersInTC(Map<String, Object> headers, TcContext tcContext) {
        tcContext.put((Object)"headers", headers);
    }

    private void executeByTrigger(SituationEventTrigger trigger, SituationInstance situationInstance) {
        log.debug("Get SituationEventTrigger from DB by id - finished");
        Situation triggerParent = trigger.getParent();
        log.info("Event received by situation [{}], processing under {} {}...", new Object[]{situationInstance.getStepContainer(), triggerParent == null ? "" : triggerParent.getClass().getSimpleName(), triggerParent == null ? "" : triggerParent.getName()});
        if (!situationInstance.getContext().tc().isFinished()) {
            List conditionParameters = trigger.getConditionParameters();
            if (conditionParameters == null || conditionParameters.isEmpty() || ConditionsHelper.isApplicable((JsonContext)situationInstance.getContext(), (List)conditionParameters)) {
                if (conditionParameters == null || conditionParameters.isEmpty()) {
                    log.info("Condition is empty, applicable anyway");
                } else {
                    log.info("Conditions are applicable, handling under {} {}...", (Object)(triggerParent == null ? "" : triggerParent.getClass().getSimpleName()), (Object)(triggerParent == null ? "" : triggerParent.getName()));
                }
                if (triggerParent != null) {
                    try {
                        this.execute(triggerParent, situationInstance.getContext());
                    }
                    catch (Exception e) {
                        log.error("Error executing situation {}", (Object)triggerParent, (Object)e);
                    }
                } else {
                    log.warn("Run situation handler was called, but situation to execute is null");
                }
            } else {
                log.info("Conditions are not applicable, skip under {} {}", (Object)(triggerParent == null ? "" : triggerParent.getClass().getSimpleName()), (Object)(triggerParent == null ? "" : triggerParent.getName()));
            }
        } else {
            log.info("Event was rejected due to context '{}' is closed", (Object)situationInstance.getContext().tc().getName());
        }
    }

    private void sendEndExceptionalSituationFinishEvent(TcContext tcContext, SituationInstance situationInstance) {
        boolean isItEndSituationForSomeone = CacheServices.getAwaitingContextsCacheService().containsKey(String.format("%s_%s", tcContext.getID(), situationInstance.getSituationId()));
        if (isItEndSituationForSomeone) {
            this.executorToMessageBrokerSender.sendEventToEndExceptionalSituationsTopic(new SituationEvent.EndExceptionalSituationFinish(situationInstance), situationInstance.getContext().getProjectUuid().toString());
        }
    }

    @ConstructorProperties(value={"templateEngine", "reportLinkCollector", "executorToMessageBrokerSender", "eventBusProvider", "stepExecutorFactory", "projectSettingsService"})
    public SituationExecutorService(TemplateEngine templateEngine, ReportLinkCollector reportLinkCollector, ExecutorToMessageBrokerSender executorToMessageBrokerSender, EventBusProvider eventBusProvider, StepExecutorFactory stepExecutorFactory, ProjectSettingsService projectSettingsService) {
        this.templateEngine = templateEngine;
        this.reportLinkCollector = reportLinkCollector;
        this.executorToMessageBrokerSender = executorToMessageBrokerSender;
        this.eventBusProvider = eventBusProvider;
        this.stepExecutorFactory = stepExecutorFactory;
        this.projectSettingsService = projectSettingsService;
    }
}

