/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.step;

import com.google.common.collect.Maps;
import java.util.Map;
import org.qubership.automation.itf.core.instance.step.SituationStepExecutor;
import org.qubership.automation.itf.core.instance.step.StepExecutor;
import org.qubership.automation.itf.core.instance.step.impl.IntegrationStepExecutor;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.model.jpa.step.SituationStep;
import org.qubership.automation.itf.core.model.jpa.step.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StepExecutorFactory {
    private static Map<Class<? extends Step>, StepExecutor> executorBindings = Maps.newHashMapWithExpectedSize((int)10);
    private IntegrationStepExecutor integrationStepExecutor;
    private SituationStepExecutor situationStepExecutor;

    @Autowired
    public StepExecutorFactory(IntegrationStepExecutor integrationStepExecutor, SituationStepExecutor situationStepExecutor) {
        this.integrationStepExecutor = integrationStepExecutor;
        this.situationStepExecutor = situationStepExecutor;
        executorBindings.put(IntegrationStep.class, integrationStepExecutor);
        executorBindings.put(SituationStep.class, situationStepExecutor);
    }

    public static void executeStatic(StepInstance stepInstance) throws Exception {
        StepExecutorFactory.getExecutor(stepInstance).execute(stepInstance);
    }

    private static StepExecutor getExecutor(StepInstance stepInstance) throws Exception {
        for (Map.Entry<Class<? extends Step>, StepExecutor> entry : executorBindings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(stepInstance.getStep().getClass())) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException(String.format("No executor found for stepInstance [%s], type [%s]", stepInstance.getStep(), stepInstance.getStep().getClass().getSimpleName()));
    }

    public void execute(StepInstance stepInstance) throws Exception {
        StepExecutorFactory.getExecutor(stepInstance).execute(stepInstance);
    }
}

