/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.automation.itf.core.instance.step.impl;

import java.util.Date;
import java.util.Objects;
import org.qubership.automation.itf.core.instance.step.StepExecutor;
import org.qubership.automation.itf.core.instance.step.impl.IntegrationStepHelper;
import org.qubership.automation.itf.core.model.event.Event;
import org.qubership.automation.itf.core.model.event.StepEvent;
import org.qubership.automation.itf.core.model.jpa.context.JsonContext;
import org.qubership.automation.itf.core.model.jpa.context.SpContext;
import org.qubership.automation.itf.core.model.jpa.instance.AbstractInstance;
import org.qubership.automation.itf.core.model.jpa.instance.step.StepInstance;
import org.qubership.automation.itf.core.model.jpa.step.IntegrationStep;
import org.qubership.automation.itf.core.util.constants.Mep;
import org.qubership.automation.itf.core.util.constants.Status;
import org.qubership.automation.itf.core.util.transport.service.report.Report;
import org.qubership.automation.itf.executor.provider.EventBusProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegrationStepExecutor
implements StepExecutor {
    public static final Logger LOGGER = LoggerFactory.getLogger(IntegrationStepExecutor.class);
    private final EventBusProvider eventBusProvider;
    private final IntegrationStepHelper integrationStepHelper;

    @Autowired
    public IntegrationStepExecutor(EventBusProvider eventBusProvider, IntegrationStepHelper integrationStepHelper) {
        this.eventBusProvider = eventBusProvider;
        this.integrationStepHelper = integrationStepHelper;
    }

    public void execute(AbstractInstance abstractInstance) throws Exception {
        StepInstance stepInstance = (StepInstance)abstractInstance;
        IntegrationStep step = (IntegrationStep)stepInstance.getStep();
        String stepIdentity = String.format("Step '%s' in '%s'", stepInstance.getStep().getName(), stepInstance.getParent());
        if (!step.isEnabled()) {
            this.eventBusProvider.post((Event)new StepEvent.Skip(stepInstance));
            LOGGER.info("{} - disabled ==> skipped", (Object)stepIdentity);
            return;
        }
        LOGGER.info("{}: execution is started", (Object)stepIdentity);
        if (step.getUnit() != null && step.getDelay() > 0L) {
            String timeUnit = step.getUnit().toLowerCase();
            LOGGER.info("{}: waiting for timeout '{}' {}...", new Object[]{stepIdentity, step.getDelay(), step.getUnit()});
            Report.info((AbstractInstance)stepInstance.getParent(), (String)String.format("Timeout for [%s]", step.getName()), (String)String.format("Waiting for [%d] %s", step.getDelay(), timeUnit));
            Thread.sleep(step.retrieveUnit().toMillis(step.getDelay()));
            LOGGER.info("{}: timeout '{}' {} is elapsed", new Object[]{stepIdentity, step.getDelay(), step.getUnit()});
            Report.info((AbstractInstance)stepInstance.getParent(), (String)String.format("Timeout for [%s]", step.getName()), (String)String.format("Timeout is elapsed: [%d] %s", step.getDelay(), timeUnit));
        }
        if (stepInstance.getContext().sp() == null) {
            stepInstance.getContext().setSP(new SpContext(stepInstance));
        }
        stepInstance.getParent().getStepInstances().add(stepInstance);
        stepInstance.setStatus(Status.IN_PROGRESS);
        stepInstance.setStartTime(new Date());
        try {
            Mep mep = step.getMep();
            switch (mep) {
                case OUTBOUND_REQUEST_RESPONSE_SYNCHRONOUS: {
                    this.integrationStepHelper.sendReceiveSync(stepInstance);
                    break;
                }
                case OUTBOUND_REQUEST_ASYNCHRONOUS: 
                case INBOUND_RESPONSE_ASYNCHRONOUS: {
                    this.integrationStepHelper.sendRequest(stepInstance);
                    break;
                }
                case OUTBOUND_RESPONSE_ASYNCHRONOUS: 
                case INBOUND_REQUEST_ASYNCHRONOUS: 
                case INBOUND_REQUEST_SYNCHRONOUS: {
                    break;
                }
                case INBOUND_REQUEST_RESPONSE_SYNCHRONOUS: {
                    this.integrationStepHelper.checkErrors(stepInstance);
                    if (((IntegrationStep)stepInstance.getStep()).returnStepTemplate() == null) break;
                    this.integrationStepHelper.sendSyncResponse(stepInstance);
                    break;
                }
                case INBOUND_RESPONSE_SYNCHRONOUS: {
                    this.integrationStepHelper.sendSyncResponse(stepInstance);
                }
            }
            this.integrationStepHelper.processOutgoingContextKeys(stepInstance);
            stepInstance.setStatus(Objects.nonNull(stepInstance.getError()) ? Status.FAILED : Status.PASSED);
            stepInstance.setEndTime(new Date());
            LOGGER.info("{}: executed successfully", (Object)stepIdentity);
            if (!stepInstance.isRetryStep()) {
                this.eventBusProvider.post((Event)new StepEvent.Finish(stepInstance));
            }
        }
        catch (Exception e) {
            stepInstance.setError((Throwable)e);
            stepInstance.setStatus(Status.FAILED);
            stepInstance.setEndTime(new Date());
            this.eventBusProvider.post((Event)new StepEvent.Terminate(stepInstance));
            throw e;
        }
    }

    public void execute(AbstractInstance step, JsonContext customDataset) throws Exception {
        this.execute(step);
    }
}

